/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.distribute.service;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.ant.distribute.utils.HttpUtil;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ExternalService {
    private Logger logger = LoggerFactory.getLogger(ExternalService.class);
    @Value(value="${ant.coop.service.url}")
    public String coopServiceUrl;
    @Value(value="${ant.pur.service.url}")
    public String purServiceUrl;
    @Value(value="${ant.system.service.url}")
    public String systemServiceUrl;
    @Value(value="${ant.prepro.service.url}")
    public String preproServiceUrl;
    @Value(value="${ant.order.service.url}")
    public String orderServiceUrl;

    public String sendToCoopService(String header, String body, String queueName, String target) {
        try {
            JSONObject param = new JSONObject();
            param.put("header", (Object)header);
            param.put("body", (Object)body);
            param.put("queueName", (Object)queueName);
            String url = "";
            switch (target) {
                case "order-service": {
                    url = this.orderServiceUrl + "/api/invoice/mq/v1/listener";
                    break;
                }
                case "coop-service": {
                    url = this.coopServiceUrl + "/ms/global/coop/v1/common/sqsMessageListener";
                    break;
                }
                case "pur-service": {
                    url = this.purServiceUrl + "/ms/global/pur/v1/common/sqsMessageListener";
                    break;
                }
                case "system-service": {
                    url = this.systemServiceUrl + "/ms/global/coop/system/v1/common/sqsMessageListener";
                    break;
                }
                case "prepro-set": {
                    url = this.preproServiceUrl + "/ms/global/preproset/v1/common/sqsMessageListener";
                    break;
                }
                default: {
                    return "";
                }
            }
            this.logger.info("\u53d1\u9001SQS\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)url);
            String cmpInfoResp = HttpUtil.sendPost((String)url, (String)param.toJSONString(), (Header[])new Header[0]);
            this.logger.info("\u53d1\u9001SQS\u56de\u590d\u62a5\u6587\uff1a{}", (Object)cmpInfoResp);
            return cmpInfoResp;
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u9001SQS\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            return "";
        }
    }
}

