/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.distribute.service;

import com.xforceplus.ant.distribute.DistributeClientApplication;
import com.xforceplus.ant.distribute.config.CoopSqsProperties;
import com.xforceplus.ant.distribute.config.SpringContextUtils;
import com.xforceplus.ant.distribute.utils.CommonTools;
import com.xforceplus.ant.distribute.utils.ScanUtils;
import com.xforceplus.xplat.aws.spring.annotation.EnableAwsClient;
import com.xforceplus.xplat.aws.spring.annotation.SQSListener;
import com.xforceplus.xplat.aws.sqs.SqsService;
import com.xforceplus.xplat.aws.sqs.listener.AbsSQSListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.wicp.tams.common.Conf;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Service;

@Service
public class SqsReceiveMessageService
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(SqsReceiveMessageService.class);
    @Autowired
    SqsService sqsService;
    @Autowired
    CoopSqsProperties coopSqsProperties;

    public void multListener() {
        System.out.println("\u591a\u8def\u76d1\u542c\u5f00\u59cb------------------------------------------------------------------------------");
        EnableAwsClient enableAwsClient = DistributeClientApplication.class.getAnnotation(EnableAwsClient.class);
        if (null == enableAwsClient) {
            return;
        }
        String packages = "com.xforceplus.ant.distribute";
        if (StringUtils.isNotEmpty((CharSequence)enableAwsClient.packages())) {
            packages = enableAwsClient.packages();
        }
        Set classes = ScanUtils.scanSubclass((String)packages, AbsSQSListener.class, (boolean)false);
        for (Class aClass : classes) {
            try {
                SQSListener annotation = aClass.getAnnotation(SQSListener.class);
                if (null == annotation) continue;
                String beanName = aClass.getSimpleName().substring(0, 1).toLowerCase() + aClass.getSimpleName().substring(1);
                AbsSQSListener listener = (AbsSQSListener)SpringContextUtils.getBean((String)beanName);
                String queueName = annotation.queueName();
                CoopSqsProperties.QueueConfig config = this.coopSqsProperties.getReceiveConfig(queueName);
                if (null == config || CommonTools.isEmpty((List)config.getPrefixs())) continue;
                ArrayList prefixs = new ArrayList(config.getPrefixs());
                String prefix = Conf.get((String)"xplat.aws.sqs.receiver.queueName.prefix");
                if (StringUtils.isNotEmpty((CharSequence)prefix)) {
                    prefixs.remove(prefix);
                }
                boolean attributeAll = annotation.attributeAll();
                String[] attributeNames = annotation.attributeNames();
                int maxNumberOfMessages = annotation.maxNumberOfMessages();
                String namespace = annotation.namespace();
                for (String ps : prefixs) {
                    System.out.println("\u961f\u5217\u540d\uff1a" + ps + queueName + "\uff1b\u7c7b\u5bf9\u8c61\uff1a" + listener.getClass().getName());
                    this.sqsService.queueReceiverListener(ps + queueName, namespace, (AbsSQSListener)new /* Unavailable Anonymous Inner Class!! */, maxNumberOfMessages, 0, attributeNames);
                }
            }
            catch (Exception e) {
                log.error("##### \u76d1\u542c\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }
        System.out.println("\u591a\u8def\u76d1\u542c\u7ed3\u675f------------------------------------------------------------------------------");
    }

    public void run(String ... args) {
        try {
            this.multListener();
        }
        catch (Exception e) {
            log.error("##### \u591a\u8def\u76d1\u542c\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
    }
}

