/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ant.distribute.utils;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ScanUtils {
    private static final ResourcePatternResolver RESOLVER = new PathMatchingResourcePatternResolver();
    private static final MetadataReaderFactory METADATA_READER_FACTORY = new SimpleMetadataReaderFactory();

    public static Set<Class<?>> scanClass(String scanPath, boolean mustConcrete) {
        String path = ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)scanPath));
        String packageSearchPath = "classpath*:" + path + "/**/*.class";
        HashSet classes = new HashSet();
        try {
            Resource[] resources;
            for (Resource resource : resources = RESOLVER.getResources(packageSearchPath)) {
                if (!resource.isReadable()) continue;
                MetadataReader metadataReader = METADATA_READER_FACTORY.getMetadataReader(resource);
                ClassMetadata classMetadata = metadataReader.getClassMetadata();
                if (mustConcrete && !classMetadata.isConcrete()) continue;
                classes.add(Class.forName(classMetadata.getClassName()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classes;
    }

    public static Set<Class<?>> scanSubclass(String scanPath, Class<?> superclass, boolean mustConcrete) {
        Set scanClass = ScanUtils.scanClass((String)scanPath, (boolean)mustConcrete);
        return scanClass.stream().filter(superclass::isAssignableFrom).collect(Collectors.toSet());
    }
}

