/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.delivery.cloud.auxiliary.operation;

import cn.hutool.crypto.digest.DigestUtil;
import com.xforceplus.delivery.cloud.auxiliary.domain.AopOperateRecord;
import com.xforceplus.delivery.cloud.auxiliary.operation.AopOp;
import com.xforceplus.delivery.cloud.auxiliary.operation.AopOpActuator;
import com.xforceplus.delivery.cloud.auxiliary.operation.AopOpStackHandler;
import com.xforceplus.delivery.cloud.common.aop.SpELContext;
import com.xforceplus.delivery.cloud.common.api.AjaxResult;
import com.xforceplus.delivery.cloud.common.api.DataDict;
import com.xforceplus.delivery.cloud.common.api.ResultCode;
import com.xforceplus.delivery.cloud.common.cache.DataDictCache;
import com.xforceplus.delivery.cloud.common.lambda.CheckedTry;
import com.xforceplus.delivery.cloud.common.util.AspectUtils;
import com.xforceplus.delivery.cloud.common.util.ExceptionUtils;
import com.xforceplus.delivery.cloud.common.util.JsonUtils;
import com.xforceplus.delivery.cloud.common.util.StringUtils;
import com.xforceplus.delivery.cloud.common.util.TraceUtils;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AopOpJoinPoint {
    private static final Logger log = LoggerFactory.getLogger(AopOpJoinPoint.class);
    protected AopOpStackHandler aopOpStack;
    protected ConcurrentMap<String, String> signatureMd5Hex16Cache = new ConcurrentHashMap<String, String>();

    protected AopOpJoinPoint(AopOpStackHandler aopOpStack) {
        this.aopOpStack = aopOpStack;
    }

    protected Object around(ProceedingJoinPoint joinPoint, AopOp aopOp) throws Throwable {
        Object returnValue = null;
        Throwable throwable = null;
        Instant now = Instant.now();
        Optional traceIdOpt = TraceUtils.getTraceId();
        if (!traceIdOpt.isPresent()) {
            TraceUtils.setMdcTraceId((String)TraceUtils.genMdcTraceId());
        }
        Logger logger = AspectUtils.getLogger((ProceedingJoinPoint)joinPoint).orElse(log);
        SpELContext spELContext = this.proceedBefore(joinPoint, aopOp);
        logger.debug("AopOp starting - {}", AopOpStackHandler.getOp());
        try {
            if (log.isDebugEnabled()) {
                logger.debug("AopOp arguments - {}: {}", AopOpStackHandler.getOp(), (Object)JsonUtils.toJson((Object)joinPoint.getArgs()));
            }
            returnValue = joinPoint.proceed();
            if (log.isDebugEnabled()) {
                logger.debug("AopOp finished - {}: {}", AopOpStackHandler.getOp(), (Object)JsonUtils.toJson((Object)returnValue));
            }
            spELContext.setResult(returnValue);
        }
        catch (Throwable e) {
            logger.debug("AopOp throwable - {}", AopOpStackHandler.getOp(), (Object)e);
            throwable = e;
            throw e;
        }
        finally {
            long millis = Duration.between(now, Instant.now()).toMillis();
            logger.debug("AopOp completed elapsed {} ms", (Object)millis);
            this.proceedAfter(spELContext, aopOp, returnValue, throwable);
            if (!traceIdOpt.isPresent()) {
                TraceUtils.clsMdcTraceId();
            }
        }
        return returnValue;
    }

    protected String getSignatureMd5Hex16(ProceedingJoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        return this.signatureMd5Hex16Cache.computeIfAbsent(methodSignature.toLongString(), CheckedTry.apply(key -> DigestUtil.md5Hex16((String)joinPoint.getTarget().getClass().getMethod(methodSignature.getName(), methodSignature.getParameterTypes()).toGenericString())));
    }

    protected SpELContext proceedBefore(ProceedingJoinPoint joinPoint, AopOp aopOp) {
        Stack<AopOperateRecord> aopOpStack = AopOpStackHandler.getStack();
        AopOperateRecord prevOp = aopOpStack.isEmpty() ? AopOpActuator.OPERATE.get() : aopOpStack.peek();
        AopOperateRecord currOp = aopOpStack.push(new AopOperateRecord());
        TraceUtils.getTraceId().ifPresent(arg_0 -> ((AopOperateRecord)currOp).setTraceId(arg_0));
        currOp.setOperateType(aopOp.operateType());
        currOp.setInvokeIdentifier(this.getSignatureMd5Hex16(joinPoint));
        SpELContext spELContext = new SpELContext((JoinPoint)joinPoint);
        spELContext.getValue(aopOp.businessKey(), String.class).ifPresent(arg_0 -> ((AopOperateRecord)currOp).setBusinessKey(arg_0));
        currOp.setBusinessTypeCode(aopOp.businessTypeCode());
        this.handleBusinessAttr(currOp, prevOp);
        String spelKeyword = aopOp.keyword();
        spELContext.getValue(spelKeyword, String.class).ifPresent(arg_0 -> ((AopOperateRecord)currOp).setKeyword(arg_0));
        currOp.setArguments(JsonUtils.toJson((Object)joinPoint.getArgs()));
        currOp.setOperateTime(LocalDateTime.now());
        return spELContext;
    }

    protected void proceedAfter(SpELContext spELContext, AopOp aopOp, Object returnValue, Throwable throwable) {
        Stack<AopOperateRecord> aopOpStack = AopOpStackHandler.getStack();
        AopOperateRecord currOp = aopOpStack.pop();
        AopOperateRecord prevOp = aopOpStack.isEmpty() ? AopOpActuator.OPERATE.get() : aopOpStack.peek();
        this.handleBusinessAttr(currOp, prevOp);
        if (throwable == null) {
            this.handleOperationAttr(spELContext, aopOp, returnValue, currOp, prevOp);
        } else {
            if (StringUtils.isBlank((CharSequence)currOp.getOperateRemark())) {
                currOp.setOperateRemark("\u7cfb\u7edf\u5f02\u5e38," + throwable.getLocalizedMessage());
            }
            currOp.setOperateState(ResultCode.FAILED.getCode());
            currOp.setStackTrace(ExceptionUtils.toStringRootCauseStackTrace((Throwable)throwable));
        }
        AopOpStackHandler.putOp(currOp);
    }

    protected void handleBusinessAttr(AopOperateRecord currOp, AopOperateRecord prevOp) {
        String businessTypeCode;
        if (StringUtils.isBlank((CharSequence)currOp.getBusinessType()) && StringUtils.isNotEmpty((CharSequence)(businessTypeCode = currOp.getBusinessTypeCode()))) {
            String businessType = DataDictCache.getInstance().getDictItem("AOP_OP_BUSINESS_TYPE", businessTypeCode).map(DataDict::getValue).orElse(DigestUtil.md5Hex16((String)businessTypeCode));
            currOp.setBusinessType(businessType);
        }
        if (prevOp == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)currOp.getBusinessTypeCode())) {
            currOp.setBusinessType(prevOp.getBusinessType());
            currOp.setBusinessTypeCode(prevOp.getBusinessTypeCode());
        }
        if (StringUtils.isBlank((CharSequence)currOp.getBusinessKey())) {
            currOp.setBusinessKey(prevOp.getBusinessKey());
        }
        if (StringUtils.isBlank((CharSequence)prevOp.getBusinessType())) {
            prevOp.setBusinessType(currOp.getBusinessType());
            prevOp.setBusinessTypeCode(currOp.getBusinessTypeCode());
        }
        if (StringUtils.isBlank((CharSequence)prevOp.getBusinessKey())) {
            prevOp.setBusinessKey(currOp.getBusinessKey());
        }
    }

    protected void handleOperationAttr(SpELContext spELContext, AopOp aopOp, Object returnValue, AopOperateRecord currOp, AopOperateRecord prevOp) {
        if (currOp.getOperateState() == null) {
            String spelOperateState = aopOp.operateState();
            if (StringUtils.isBlank((CharSequence)spelOperateState)) {
                if (returnValue instanceof AjaxResult) {
                    currOp.setOperateState(((AjaxResult)returnValue).getCode());
                }
            } else {
                spELContext.getValue(spelOperateState, Integer.class).ifPresent(arg_0 -> ((AopOperateRecord)currOp).setOperateState(arg_0));
            }
        }
        if (currOp.getOperateRemark() == null) {
            String spelOperateRemark = aopOp.operateRemark();
            if (StringUtils.isBlank((CharSequence)spelOperateRemark)) {
                if (returnValue instanceof AjaxResult) {
                    currOp.setOperateRemark(((AjaxResult)returnValue).getMessage());
                }
            } else {
                spELContext.getValue(spelOperateRemark, String.class).ifPresent(arg_0 -> ((AopOperateRecord)currOp).setOperateRemark(arg_0));
            }
        }
        if (currOp.getReturnValue() == null && returnValue != null) {
            String spelReturnValue = aopOp.returnValue();
            if (StringUtils.isBlank((CharSequence)spelReturnValue)) {
                if (returnValue instanceof AjaxResult) {
                    spelReturnValue = "#{#r.data}";
                }
                if (returnValue instanceof String) {
                    currOp.setReturnValue((String)returnValue);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)spelReturnValue)) {
                returnValue = spELContext.getValue(spelReturnValue, Object.class);
            }
            currOp.setReturnValue(JsonUtils.toJson((Object)returnValue));
        }
    }
}

