/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.delivery.cloud.auxiliary.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.delivery.cloud.auxiliary.domain.AopRetryableQueue;
import com.xforceplus.delivery.cloud.auxiliary.service.AuxiliaryAopRetryableQueueService;
import com.xforceplus.delivery.cloud.common.api.AjaxResult;
import com.xforceplus.delivery.cloud.common.api.ViewResult;
import com.xforceplus.delivery.cloud.common.properties.GlobalProperties;
import com.xforceplus.delivery.cloud.common.util.DateUtils;
import com.xforceplus.delivery.cloud.common.util.SpringUtils;
import com.xforceplus.delivery.cloud.common.util.StringUtils;
import com.xforceplus.delivery.cloud.gen.commons.entity.AopRetryableQueueEntity;
import com.xforceplus.delivery.cloud.gen.commons.service.IAopRetryableQueueService;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuxiliaryAopRetryableQueueServiceImpl
implements AuxiliaryAopRetryableQueueService {
    private static final Logger log = LoggerFactory.getLogger(AuxiliaryAopRetryableQueueServiceImpl.class);
    @Autowired
    private GlobalProperties globalProperties;
    @Autowired
    private IAopRetryableQueueService iAopRetryableQueueService;

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean removeByWrapper(LambdaQueryWrapper<AopRetryableQueueEntity> lambdaQuery) {
        return this.iAopRetryableQueueService.remove(lambdaQuery);
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public AjaxResult removeByExample(AopRetryableQueueEntity aopRetryableQueueEntity) {
        Long retryQueueId = aopRetryableQueueEntity.getId();
        boolean affectedRows = retryQueueId == null || retryQueueId == 0L ? this.doBatchRemove(aopRetryableQueueEntity) : this.iAopRetryableQueueService.removeById((Serializable)retryQueueId);
        return ViewResult.success().data((Object)affectedRows);
    }

    private boolean doBatchRemove(AopRetryableQueueEntity dispatchRetryQueue) {
        boolean affectedRows;
        String[] aCleanTime;
        String cleanTime;
        String eventName = dispatchRetryQueue.getEvtname();
        String keyword = dispatchRetryQueue.getKeyword();
        log.debug("retryable queue clean starting: [{}]{}", (Object)eventName, (Object)keyword);
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery(AopRetryableQueueEntity.class);
        lambdaQuery.eq(AopRetryableQueueEntity::getEvtname, (Object)eventName);
        lambdaQuery.eq(AopRetryableQueueEntity::getSvcname, (Object)StringUtils.blankToDefault((CharSequence)dispatchRetryQueue.getSvcname(), (String)SpringUtils.getAppName()));
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            if (keyword.contains("%")) {
                lambdaQuery.like(AopRetryableQueueEntity::getKeyword, (Object)keyword);
            } else {
                lambdaQuery.eq(AopRetryableQueueEntity::getKeyword, (Object)keyword);
            }
        }
        if (dispatchRetryQueue instanceof AopRetryableQueue && StringUtils.isNotBlank((CharSequence)(cleanTime = ((AopRetryableQueue)dispatchRetryQueue).getCleanTime())) && (aCleanTime = cleanTime.split("~")).length == 2) {
            lambdaQuery.between(AopRetryableQueueEntity::getCreateTime, (Object)DateUtils.toLocalDateTime((String)aCleanTime[0]), (Object)DateUtils.toLocalDateTime((String)aCleanTime[1]));
        }
        lambdaQuery.last(" limit " + this.globalProperties.getRemoveBatchSize());
        do {
            log.debug("dispatch queue clearing: [{}]{}", (Object)eventName, (Object)keyword);
            affectedRows = this.iAopRetryableQueueService.remove((Wrapper)lambdaQuery);
            log.debug("dispatch queue deleted affected: [{}]{} -> {}", new Object[]{eventName, keyword, affectedRows});
        } while (affectedRows);
        log.debug("dispatch queue clean finished: [{}]{}", (Object)eventName, (Object)keyword);
        return true;
    }
}

