/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.delivery.cloud.auxiliary.service.impl;

import cn.hutool.core.util.ArrayUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.xforceplus.delivery.cloud.auxiliary.domain.OptKeyTrace;
import com.xforceplus.delivery.cloud.auxiliary.domain.OptKeyTraceExample;
import com.xforceplus.delivery.cloud.auxiliary.properties.OptKeyTraceProperties;
import com.xforceplus.delivery.cloud.auxiliary.service.AuxiliaryOptKeyTraceService;
import com.xforceplus.delivery.cloud.common.api.AjaxResult;
import com.xforceplus.delivery.cloud.common.api.ViewResult;
import com.xforceplus.delivery.cloud.common.component.EntityDomainExtra;
import com.xforceplus.delivery.cloud.common.properties.GlobalProperties;
import com.xforceplus.delivery.cloud.common.util.DateUtils;
import com.xforceplus.delivery.cloud.common.util.JsonUtils;
import com.xforceplus.delivery.cloud.common.util.MapUtils;
import com.xforceplus.delivery.cloud.common.util.StringUtils;
import com.xforceplus.delivery.cloud.common.util.TraceUtils;
import com.xforceplus.delivery.cloud.gen.commons.entity.OptKeyTraceEntity;
import com.xforceplus.delivery.cloud.gen.commons.service.IOptKeyTraceService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuxiliaryOptKeyTraceServiceImpl
implements AuxiliaryOptKeyTraceService {
    private static final Logger log = LoggerFactory.getLogger(AuxiliaryOptKeyTraceServiceImpl.class);
    @Autowired
    private GlobalProperties globalProperties;
    @Autowired
    private OptKeyTraceProperties optKeyTraceProperties;
    @Autowired
    private IOptKeyTraceService iOptKeyTraceService;

    @Override
    public OptKeyTraceEntity saveEntityExtra(OptKeyTraceEntity entity) {
        String tid;
        if (entity.getCreateTime() == null) {
            entity.setCreateTime(LocalDateTime.now());
        }
        if (StringUtils.isBlank((CharSequence)(tid = entity.getTid()))) {
            entity.setTid(TraceUtils.getTraceId().orElseGet(TraceUtils::genMdcTraceId));
        }
        if (entity.getSeq() == null) {
            entity.setSeq(Long.valueOf(System.currentTimeMillis()));
        }
        this.iOptKeyTraceService.save((Object)entity);
        return entity;
    }

    @Override
    public OptKeyTraceEntity saveEntityExtra(Map<String, Object> dataMap, String optKeyName) {
        return this.saveEntityExtra(new OptKeyTraceEntity(), dataMap, optKeyName);
    }

    @Override
    public OptKeyTraceEntity saveEntityExtra(OptKeyTraceEntity entity, Map<String, Object> dataMap, String optKeyName) {
        entity.setOpt(optKeyName);
        entity.setKey(this.expandOptKey(dataMap, optKeyName));
        return this.saveEntityExtra(this.expandOptExtra(entity, dataMap));
    }

    protected String expandOptKey(Map<String, Object> dataMap, String optKeyName) {
        StringJoiner joiner = new StringJoiner("-");
        String[] optKeys = this.optKeyTraceProperties.getOptKeys().get(optKeyName);
        Stream.of(optKeys).forEach(key -> joiner.add((String)dataMap.get(key)));
        return joiner.toString();
    }

    protected OptKeyTraceEntity expandOptExtra(OptKeyTraceEntity entity, Map<String, Object> dataMap) {
        EntityDomainExtra extra = new EntityDomainExtra((Serializable)entity);
        String[] extraKeys = this.optKeyTraceProperties.getOptExtra().get(entity.getOpt());
        extra.extraByMap((e, name, value) -> ArrayUtil.contains((Object[])extraKeys, (Object)name), dataMap);
        return (OptKeyTraceEntity)extra.toEntityObj();
    }

    @Override
    public JSONObject[] diffExtra(OptKeyTrace optKeyTrace) {
        return this.diffExtra(optKeyTrace.getOpt(), optKeyTrace.getKey(), optKeyTrace.getTid());
    }

    @Override
    public JSONObject[] diffExtra(String opt, String key, String tid) {
        OptKeyTraceEntity oldEntity = null;
        OptKeyTraceEntity newEntity = null;
        OptKeyTraceEntity[] entities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.iOptKeyTraceService.lambdaQuery().eq(OptKeyTraceEntity::getOpt, (Object)opt)).eq(OptKeyTraceEntity::getKey, (Object)key)).list().toArray(new OptKeyTraceEntity[0]);
        Arrays.sort(entities, Comparator.comparing(OptKeyTraceEntity::getSeq));
        for (int i = 0; i < entities.length; ++i) {
            if (!entities[i].getTid().equals(tid)) continue;
            newEntity = entities[i];
            if (i <= 0) break;
            oldEntity = entities[i - 1];
            break;
        }
        JSONObject oldExtraData = this.wrapExtra(oldEntity);
        JSONObject newExtraData = this.wrapExtra(newEntity);
        MapUtils.diff((Map)oldExtraData, (Map)newExtraData);
        return new JSONObject[]{oldExtraData, newExtraData};
    }

    protected JSONObject wrapExtra(OptKeyTraceEntity entity) {
        return Optional.ofNullable(entity).map(e -> StringUtils.trimToNull((CharSequence)entity.getExtraData())).flatMap(extraData -> JsonUtils.toBean((String)extraData, JSONObject.class)).orElseGet(JSONObject::new);
    }

    @Override
    public AjaxResult removeByExample(OptKeyTraceExample optKeyTraceExample) {
        Long exampleId = optKeyTraceExample.getId();
        if (exampleId == null || exampleId == 0L) {
            return this.doBatchRemove(optKeyTraceExample);
        }
        boolean affectedRows = this.iOptKeyTraceService.removeById((Serializable)exampleId);
        return ViewResult.success().data((Object)affectedRows);
    }

    private AjaxResult doBatchRemove(OptKeyTraceExample optKeyTraceExample) {
        boolean affectedRows;
        StringJoiner errors = new StringJoiner(", ");
        String opt = optKeyTraceExample.getOpt();
        String key = optKeyTraceExample.getKey();
        String cleanTime = optKeyTraceExample.getCleanTime();
        log.debug("opt key clean starting: [{}]{}->{}", new Object[]{cleanTime, opt, key});
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery(OptKeyTraceEntity.class);
        if (StringUtils.isBlank((CharSequence)opt)) {
            errors.add("\u64cd\u4f5c\u7801");
        } else {
            lambdaQuery.eq(OptKeyTraceEntity::getOpt, (Object)opt);
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            errors.add("\u5173\u952e\u5b57");
        } else {
            lambdaQuery.eq(OptKeyTraceEntity::getKey, (Object)key);
        }
        if (StringUtils.isBlank((CharSequence)cleanTime)) {
            errors.add("\u6e05\u7406\u65f6\u95f4");
        } else {
            String[] aCleanTime = cleanTime.split("~");
            if (aCleanTime.length == 2) {
                lambdaQuery.between(OptKeyTraceEntity::getCreateTime, (Object)DateUtils.toLocalDateTime((String)aCleanTime[0]), (Object)DateUtils.toLocalDateTime((String)aCleanTime[1]));
            } else {
                return ViewResult.validateFailed((String)"\u65e0\u6548\u7684\u6e05\u7406\u65f6\u95f4");
            }
        }
        lambdaQuery.last(" limit " + this.globalProperties.getRemoveBatchSize());
        do {
            log.debug("opt key clearing: [{}]{}->{}", new Object[]{cleanTime, opt, key});
            affectedRows = this.iOptKeyTraceService.remove((Wrapper)lambdaQuery);
            log.debug("opt key deleted affected: [{}]{}->{} >> {}", new Object[]{cleanTime, opt, key, affectedRows});
        } while (affectedRows);
        log.debug("opt key clean finished: [{}]{}->{}", new Object[]{cleanTime, opt, key});
        return ViewResult.success();
    }
}

