/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.delivery.cloud.auxiliary.xxljob;

import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.xforceplus.delivery.cloud.auxiliary.xxljob.AbstractXxlJobParam;
import com.xforceplus.delivery.cloud.common.util.DateUtils;
import com.xforceplus.delivery.cloud.common.util.JsonUtils;
import com.xforceplus.delivery.cloud.common.util.StringUtils;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.log.XxlJobLogger;
import com.xxl.job.core.util.ShardingUtil;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXxlJobHandler<E, P extends AbstractXxlJobParam> {
    private static final Logger log = LoggerFactory.getLogger(AbstractXxlJobHandler.class);

    protected void xxlJobLog(String appendLogPattern, Object ... appendLogArguments) {
        log.debug(appendLogPattern, appendLogArguments);
        XxlJobLogger.log((String)appendLogPattern, (Object[])appendLogArguments);
    }

    protected boolean shardingByEntityId(E entity) {
        ShardingUtil.ShardingVO shardingVO = ShardingUtil.getShardingVo();
        if (shardingVO == null) {
            return true;
        }
        int shardingTotal = shardingVO.getTotal();
        int shardingIndex = shardingVO.getIndex();
        return this.getId(entity) % (long)shardingTotal == (long)shardingIndex;
    }

    protected Long getId(E entity) {
        SFunction<E, Long> sFunction = this.getIdFunction();
        return (Long)sFunction.apply(entity);
    }

    protected ReturnT<String> doJobHandle(Class<P> clazz, String params) throws Exception {
        this.xxlJobLog("xxl job handle starting=>{}@{}", clazz.getSimpleName(), params);
        ShardingUtil.ShardingVO shardingVO = ShardingUtil.getShardingVo();
        if (shardingVO != null) {
            this.xxlJobLog("xxl job handle sharding=>[{}/{}]", shardingVO.getIndex(), shardingVO.getTotal());
        }
        this.doJobHandle(this.initJobParam(clazz, params));
        this.xxlJobLog("xxl job handle completed", new Object[0]);
        return IJobHandler.SUCCESS;
    }

    protected Optional<LocalDateTime> parseDateTime(String sLocalDate) {
        LocalDateTime localDateTime;
        if (StringUtils.isBlank((CharSequence)sLocalDate)) {
            return Optional.empty();
        }
        switch (sLocalDate.length()) {
            case 7: {
                localDateTime = DateUtils.toLocalDate((String)(sLocalDate + "01"), (String)"yyyy-MM").atStartOfDay();
                break;
            }
            case 10: {
                localDateTime = DateUtils.toLocalDate((String)sLocalDate, (String)"yyyy-MM-dd").atStartOfDay();
                break;
            }
            case 19: {
                localDateTime = DateUtils.toLocalDateTime((String)sLocalDate, (String)"yyyy-MM-dd HH:mm:ss");
                break;
            }
            default: {
                throw new IllegalArgumentException("\u914d\u7f6e\u7684\u65e5\u671f\u65e0\u6548#" + sLocalDate);
            }
        }
        return Optional.of(localDateTime);
    }

    protected P initJobParam(Class<P> clazz, String params) {
        LocalDateTime lastDateTime;
        LocalDateTime firstDateTime;
        AbstractXxlJobParam xxlJobParam;
        if (StringUtils.isNotBlank((CharSequence)params)) {
            JSONObject jsonParam = JSONObject.parseObject((String)params);
            String sFirstDate = null;
            if (jsonParam.containsKey((Object)"firstDate")) {
                sFirstDate = (String)jsonParam.remove((Object)"firstDate");
            } else if (jsonParam.containsKey((Object)"firstDateTime")) {
                sFirstDate = (String)jsonParam.remove((Object)"firstDateTime");
            }
            String sLastDate = null;
            if (jsonParam.containsKey((Object)"lastDate")) {
                sLastDate = (String)jsonParam.remove((Object)"lastDate");
            } else if (jsonParam.containsKey((Object)"lastDateTime")) {
                sLastDate = (String)jsonParam.remove((Object)"lastDateTime");
            }
            xxlJobParam = (AbstractXxlJobParam)JsonUtils.fromJson((String)params, clazz);
            this.parseDateTime(sFirstDate).ifPresent(xxlJobParam::setFirstDateTime);
            this.parseDateTime(sLastDate).ifPresent(xxlJobParam::setLastDateTime);
        } else {
            xxlJobParam = (AbstractXxlJobParam)ReflectUtil.newInstance(clazz, (Object[])new Object[0]);
        }
        Integer limitRows = xxlJobParam.getLimitRows();
        if (limitRows == null) {
            xxlJobParam.setLimitRows(Runtime.getRuntime().availableProcessors() * 10);
        }
        if ((firstDateTime = (xxlJobParam = this.checkJobParam(xxlJobParam)).getFirstDateTime()) == null) {
            this.getEarlyDateTime(xxlJobParam).ifPresent(xxlJobParam::setFirstDateTime);
        }
        if ((lastDateTime = xxlJobParam.getLastDateTime()) == null) {
            xxlJobParam.setLastDateTime(LocalDateTime.now());
        }
        return (P)xxlJobParam;
    }

    protected void doJobHandle(P jobParam) {
        LocalDateTime sLocalDateTime = ((AbstractXxlJobParam)jobParam).getFirstDateTime();
        LocalDateTime eLocalDateTime = ((AbstractXxlJobParam)jobParam).getLastDateTime();
        this.xxlJobLog("xxl job handle scope[{}~{}]=>{}", sLocalDateTime, eLocalDateTime, jobParam);
        while (sLocalDateTime.isBefore(eLocalDateTime)) {
            this.doJobHandle(jobParam, sLocalDateTime, sLocalDateTime.plusDays(1L));
            sLocalDateTime = sLocalDateTime.plusDays(1L);
        }
    }

    protected void doJobHandle(P jobParam, LocalDateTime sDateTime, LocalDateTime eDateTime) {
        List entities;
        int totalRows;
        long minEntityId = 0L;
        Integer limitRows = ((AbstractXxlJobParam)jobParam).getLimitRows();
        String limitSql = " limit 0," + limitRows;
        this.xxlJobLog("xxl job handle scope processing[{}~{}]", sDateTime, eDateTime);
        do {
            entities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery(jobParam).gt(this.getIdFunction(), (Object)minEntityId)).between(sDateTime != null, this.getDateTimeFunction(), (Object)sDateTime, (Object)eDateTime)).last(limitSql)).list();
            entities.stream().filter(this::shardingByEntityId).forEach(this::handleEntity);
            OptionalLong maxIdOpt = entities.stream().mapToLong(this::getId).max();
            if (!maxIdOpt.isPresent()) continue;
            long maxEntityId = maxIdOpt.getAsLong();
            if (minEntityId == maxEntityId) {
                this.xxlJobLog("\u4e24\u6b21\u67e5\u8be2\u7684\u6700\u5927ID\u76f8\u540c{}", maxEntityId);
                break;
            }
            minEntityId = maxEntityId;
        } while ((totalRows = entities.size()) >= limitRows);
    }

    protected abstract SFunction<E, Long> getIdFunction();

    protected abstract SFunction<E, LocalDateTime> getDateTimeFunction();

    protected abstract LambdaQueryChainWrapper<E> lambdaQuery(P var1);

    protected abstract void handleEntity(E var1);

    protected P checkJobParam(P jobParam) {
        return jobParam;
    }

    protected Optional<LocalDateTime> getEarlyDateTime(P jobParam) {
        return Optional.empty();
    }
}

