SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;
-- ----------------------------
-- DROP TABLE IF EXISTS `opt_key_trace`;
CREATE TABLE IF NOT EXISTS `opt_key_trace`
(
    `id`          bigint(20) NOT NULL AUTO_INCREMENT,
    `tid`         varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '跟踪号',
    `seq`         bigint(20)                                                    DEFAULT NULL COMMENT '顺序号',
    `opt`         varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci  DEFAULT NULL COMMENT '操作码',
    `key`         varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '关键字',
    `md5`         char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci     DEFAULT NULL COMMENT 'MD5(32)',
    `create_time` datetime   NOT NULL                                           DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `extra_data`  json                                                          DEFAULT NULL COMMENT '扩展数据',
    `reserved1`   varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '预留字段1',
    `reserved2`   varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '预留字段2',
    `reserved3`   varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '预留字段3',
    PRIMARY KEY (`id`),
    KEY `idx_tid` (`tid`),
    KEY `idx_opt_key` (`key`, `opt`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_general_ci COMMENT ='操作键跟踪表';

SET FOREIGN_KEY_CHECKS = 1;