/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.delivery.cloud.auxiliary.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xforceplus.delivery.cloud.auxiliary.domain.AopRetryableQueue;
import com.xforceplus.delivery.cloud.auxiliary.retryable.RetryableDispatchRetryer;
import com.xforceplus.delivery.cloud.auxiliary.service.AuxiliaryAopRetryableQueueService;
import com.xforceplus.delivery.cloud.common.api.AjaxResult;
import com.xforceplus.delivery.cloud.common.api.PageResult;
import com.xforceplus.delivery.cloud.common.api.ViewResult;
import com.xforceplus.delivery.cloud.gen.commons.entity.AopRetryableQueueEntity;
import com.xforceplus.delivery.cloud.gen.commons.service.IAopRetryableQueueService;
import com.xforceplus.delivery.cloud.mybatis.ExampleWrapper;
import com.xforceplus.delivery.cloud.mybatis.PageQueryStringHandler;
import com.xforceplus.delivery.cloud.mybatis.ViewPage;
import com.xforceplus.delivery.cloud.webmvc.support.QueryString;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/retryable/"})
@Api(tags={"\u5206\u53d1\u961f\u5217\u63a7\u5236\u5668"})
public class AopRetryableQueueController {
    private static final Logger log = LoggerFactory.getLogger(AopRetryableQueueController.class);
    @Autowired
    private RetryableDispatchRetryer retryableDispatchRetryer;
    @Autowired
    private IAopRetryableQueueService iAopRetryableQueueService;
    @Autowired
    private AuxiliaryAopRetryableQueueService auxiliaryAopRetryableQueueService;

    @PostMapping(value={"/pageList"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5206\u53d1\u961f\u5217")
    @PreAuthorize(value="hasAuthority('dispatch:retry:list')")
    public PageResult<AopRetryableQueueEntity> pageList(@RequestBody Map<String, String> params, @QueryString(handler={PageQueryStringHandler.class}) Page<AopRetryableQueueEntity> page) {
        return ViewPage.of((IPage)this.iAopRetryableQueueService.page(page, (Wrapper)new ExampleWrapper(AopRetryableQueueEntity.class, params)));
    }

    @PostMapping(value={"/queue/retry"})
    @ApiOperation(value="\u91cd\u65b0\u6267\u884c\u961f\u5217\u4e2d\u7684\u6570\u636e\u5206\u53d1\u4efb\u52a1")
    @PreAuthorize(value="hasAuthority('dispatch:queue:retry')")
    public AjaxResult doQueueRetry(@RequestBody AopRetryableQueueEntity aopRetryableQueueEntity) {
        return this.retryableDispatchRetryer.doRetryableDispatch(aopRetryableQueueEntity);
    }

    @PostMapping(value={"/queue/removeByIds"})
    @ApiOperation(value="\u901a\u8fc7ID\u96c6\u5408\u5220\u9664\u6267\u884c\u961f\u5217\u4e2d\u7684\u6570\u636e\u5206\u53d1\u4efb\u52a1")
    @PreAuthorize(value="hasAuthority('dispatch:queue:remove')")
    public AjaxResult removeByIds(@RequestBody Collection<String> idList) {
        return ViewResult.of((boolean)this.iAopRetryableQueueService.removeByIds(idList));
    }

    @PostMapping(value={"/queue/removeByExample"})
    @ApiOperation(value="\u901a\u8fc7ID/\u670d\u52a1/\u4e8b\u4ef6/\u5173\u952e\u5b57\u7684\u7ec4\u5408\u5220\u9664(ID\u4f18\u5148)")
    @PreAuthorize(value="hasAuthority('dispatch:queue:remove')")
    public AjaxResult removeByExample(@RequestBody AopRetryableQueue dispatchRetryQueue) {
        return this.auxiliaryAopRetryableQueueService.removeByExample(dispatchRetryQueue);
    }
}

