/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.delivery.cloud.auxiliary.operation;

import com.xforceplus.delivery.cloud.auxiliary.domain.AopOperateRecord;
import com.xforceplus.delivery.cloud.auxiliary.operation.AopOpBeanPostProcessor;
import com.xforceplus.delivery.cloud.common.api.AjaxResult;
import com.xforceplus.delivery.cloud.common.api.ViewResult;
import com.xforceplus.delivery.cloud.common.util.StringUtils;
import com.xforceplus.delivery.cloud.gen.commons.entity.AopOperateRecordEntity;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AopOpActuator {
    private static final Logger log = LoggerFactory.getLogger(AopOpActuator.class);
    public static final ThreadLocal<AopOperateRecord> OPERATE = new ThreadLocal();
    @Autowired
    private AopOpBeanPostProcessor aopOpBeanPostProcessor;

    public AjaxResult executeOperate(AopOperateRecord aopOperateRecord) {
        try {
            OPERATE.set(aopOperateRecord);
            AjaxResult ajaxResult = this.getInvokeIdentifier(aopOperateRecord).map(identifier -> this.aopOpBeanPostProcessor.invokeForJson((String)identifier, aopOperateRecord.getArguments())).orElse((AjaxResult)ViewResult.failed((String)String.format("\u6267\u884c[%s$%s]\u5931\u8d25", aopOperateRecord.getBusinessType(), aopOperateRecord.getOperateType())));
            return ajaxResult;
        }
        finally {
            OPERATE.remove();
        }
    }

    private Optional<String> getInvokeIdentifier(AopOperateRecordEntity aopOperateRecord) {
        String invokeIdentifier = aopOperateRecord.getInvokeIdentifier();
        return Optional.ofNullable(StringUtils.trimToNull((CharSequence)invokeIdentifier));
    }
}

