/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.delivery.cloud.auxiliary.operation;

import cn.hutool.crypto.digest.DigestUtil;
import com.xforceplus.delivery.cloud.auxiliary.operation.AopOp;
import com.xforceplus.delivery.cloud.auxiliary.operation.AopOpInitialHandler;
import com.xforceplus.delivery.cloud.common.component.MyMethodAnnotationBeanPostProcessor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AopOpBeanPostProcessor
extends MyMethodAnnotationBeanPostProcessor<AopOp> {
    private static final Logger log = LoggerFactory.getLogger(AopOpBeanPostProcessor.class);
    @Autowired(required=false)
    private AopOpInitialHandler aopOpHandler;

    public AopOpBeanPostProcessor() {
        super(AopOp.class);
    }

    protected String getIdentifier(String beanName, Method method, AopOp annotation) {
        String toGenericString = method.toGenericString();
        String md5Hex16 = DigestUtil.md5Hex16((String)toGenericString);
        log.debug("AopOpIDMd5Hex16[{}] <- {}", (Object)md5Hex16, (Object)toGenericString);
        return md5Hex16;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return Optional.ofNullable(this.aopOpHandler).flatMap(aoh -> aoh.handleAopOp(bean, beanName)).map(m -> this.handleAopOp((Map<String, Method>)m, bean)).orElseGet(() -> super.postProcessAfterInitialization(bean, beanName));
    }

    protected Object handleAopOp(Map<String, Method> methodMap, Object bean) {
        methodMap.forEach((k, method) -> {
            this.methods.put(k, method);
            this.targets.put(k, bean);
        });
        return bean;
    }
}

