/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.delivery.cloud.auxiliary.operation;

import com.xforceplus.delivery.cloud.gen.commons.entity.AopOperateRecordEntity;
import com.xforceplus.delivery.cloud.gen.commons.service.IAopOperateRecordService;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class AopOpConsumer
implements Runnable,
ApplicationRunner,
DisposableBean,
Observer {
    private static final Logger log = LoggerFactory.getLogger(AopOpConsumer.class);
    private Thread thread;
    private final int batchSize = 30;
    private final BlockingQueue<AopOperateRecordEntity> blockingQueue;
    private final List<AopOperateRecordEntity> aopOperateRecords = new ArrayList<AopOperateRecordEntity>(30);
    @Autowired
    private IAopOperateRecordService iAopOperateRecordService;

    public AopOpConsumer() {
        this.blockingQueue = new LinkedBlockingQueue<AopOperateRecordEntity>();
        this.thread = new Thread((Runnable)this, "aop-opera-rec-consumer");
    }

    public void destroy() throws Exception {
        this.thread.interrupt();
    }

    @Override
    public void run() {
        while (!this.thread.isInterrupted()) {
            try {
                this.checkAndSave();
            }
            catch (Exception e) {
                log.warn("Check and saving operate failure", (Throwable)e);
            }
        }
    }

    private void checkAndSave() throws InterruptedException {
        AopOperateRecordEntity aopOperateRecord;
        this.aopOperateRecords.clear();
        for (int size = 0; size < this.batchSize && (aopOperateRecord = this.blockingQueue.poll(200L, TimeUnit.MILLISECONDS)) != null; ++size) {
            this.aopOperateRecords.add(aopOperateRecord);
        }
        if (!this.aopOperateRecords.isEmpty()) {
            this.iAopOperateRecordService.saveBatch(this.aopOperateRecords);
        }
    }

    public void run(ApplicationArguments args) throws Exception {
        this.thread.start();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.blockingQueue.add((AopOperateRecordEntity)arg);
    }
}

