/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.delivery.cloud.auxiliary.operation;

import com.xforceplus.delivery.cloud.auxiliary.domain.AopOperateRecord;
import com.xforceplus.delivery.cloud.auxiliary.operation.AopOpConsumer;
import com.xforceplus.delivery.cloud.common.api.AjaxResult;
import com.xforceplus.delivery.cloud.common.api.ICode;
import com.xforceplus.delivery.cloud.common.api.ResultCode;
import com.xforceplus.delivery.cloud.common.util.BeanUtils;
import com.xforceplus.delivery.cloud.common.util.JsonUtils;
import com.xforceplus.delivery.cloud.common.util.ReflectUtils;
import com.xforceplus.delivery.cloud.common.util.SpringUtils;
import com.xforceplus.delivery.cloud.common.util.StringUtils;
import java.time.LocalDateTime;
import java.util.Observable;
import java.util.Optional;
import java.util.Stack;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AopOpStackHandler
extends Observable {
    private static final Logger log = LoggerFactory.getLogger(AopOpStackHandler.class);
    private static final ThreadLocal<Stack<AopOperateRecord>> THREAD_LOCAL = ThreadLocal.withInitial(Stack::new);

    public AopOpStackHandler(AopOpConsumer aopOpConsumer) {
        this.addObserver(aopOpConsumer);
    }

    public static Stack<AopOperateRecord> getStack() {
        return THREAD_LOCAL.get();
    }

    public static Optional<AopOperateRecord> getOp() {
        if (THREAD_LOCAL.get().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(THREAD_LOCAL.get().peek());
    }

    public static void wrapOp(AjaxResult ajaxResult) {
        AopOpStackHandler.getOp().ifPresent(op -> AopOpStackHandler.wrapOp(op, ajaxResult));
    }

    public static void wrapOp(AopOperateRecord aopOperateRecord, AjaxResult ajaxResult) {
        if (aopOperateRecord.getOperateState() == null) {
            aopOperateRecord.setOperateState(ajaxResult.getCode());
        }
        if (aopOperateRecord.getOperateRemark() == null) {
            aopOperateRecord.setOperateRemark(ajaxResult.getMessage());
        }
        if (aopOperateRecord.getReturnValue() == null) {
            ReflectUtils.fieldValue((Object)ajaxResult, (String)"data", null).ifPresent(d -> aopOperateRecord.setReturnValue(JsonUtils.toJson((Object)d)));
        }
    }

    public static void putOp(ICode iCode) {
        AopOpStackHandler.putOp(iCode.getCode(), iCode.getMessage());
    }

    public static void putOp(String operateRemark) {
        AopOpStackHandler.putOp(ResultCode.SUCCESS.getCode(), operateRemark);
    }

    public static void putOp(int operateState, String operateRemark) {
        AopOperateRecord aopOperateRecord = AopOpStackHandler.getOp().flatMap(op -> BeanUtils.copyObject((Object)op, AopOperateRecord.class)).orElseGet(AopOperateRecord::new);
        aopOperateRecord.setOperateRemark(operateRemark);
        aopOperateRecord.setOperateState(operateState);
        aopOperateRecord.setOperateTime(LocalDateTime.now());
        aopOperateRecord.setOperateType(40);
        AopOpStackHandler.putOp(aopOperateRecord);
    }

    public static void putOp(AopOperateRecord aopOperateRecord) {
        aopOperateRecord.setKeyword(StringUtils.maxLength((CharSequence)aopOperateRecord.getKeyword(), (int)997));
        aopOperateRecord.setBusinessKey(StringUtils.maxLength((CharSequence)aopOperateRecord.getBusinessKey(), (int)252));
        aopOperateRecord.setOperateRemark(StringUtils.maxLength((CharSequence)aopOperateRecord.getOperateRemark(), (int)997));
        SpringUtils.getBean(AopOpStackHandler.class).ifPresent(handler -> {
            handler.setChanged();
            handler.notifyObservers((Object)aopOperateRecord);
        });
    }
}

