/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.delivery.cloud.auxiliary.retryable;

import com.xforceplus.delivery.cloud.auxiliary.retryable.IRetryableDispatcher;
import com.xforceplus.delivery.cloud.auxiliary.retryable.RetryableDispatchRetryer;
import com.xforceplus.delivery.cloud.transaction.SpringTxCallEventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class RetryableDispatchExecutor
implements IRetryableDispatcher {
    private static final Logger log = LoggerFactory.getLogger(RetryableDispatchExecutor.class);
    @Autowired
    private RetryableDispatchRetryer retryableDispatchRetryer;
    @Autowired
    private SpringTxCallEventPublisher springTxCallEventPublisher;

    @Override
    public void doDispatch(String eventName, String keyword, Object ... args) {
        this.retryableDispatchRetryer.doRetryableDispatch(eventName, keyword, args);
    }

    @Override
    @Async(value="xRetryableAsyncExecutor")
    public void doDispatchAsync(String eventName, String keyword, Object ... args) {
        this.doDispatch(eventName, keyword, args);
    }

    @Override
    public void doDispatchAfterCommit(String eventName, String keyword, Object ... args) {
        log.trace("retryable dispatch tx commit after, evt={},key={}", (Object)eventName, (Object)keyword);
        this.springTxCallEventPublisher.callAfterCommit(() -> this.doDispatch(eventName, keyword, args));
    }

    @Override
    public void doDispatchAfterCommitAsync(String eventName, String keyword, Object ... args) {
        log.trace("retryable dispatch tx commit after async, evt={},key={}", (Object)eventName, (Object)keyword);
        this.springTxCallEventPublisher.callAfterCommitAsync(() -> this.doDispatch(eventName, keyword, args));
    }

    @Override
    public void doDispatchAfterCompleteAsync(String eventName, String keyword, Object ... args) {
        log.trace("retryable dispatch tx complete after async, evt={},key={}", (Object)eventName, (Object)keyword);
        this.springTxCallEventPublisher.callAfterCompleteAsync(() -> this.doDispatch(eventName, keyword, args));
    }
}

