/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.delivery.cloud.auxiliary.retryable;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xforceplus.delivery.cloud.auxiliary.domain.AopRetryableJobarg;
import com.xforceplus.delivery.cloud.auxiliary.properties.RetryableDispatchProperties;
import com.xforceplus.delivery.cloud.auxiliary.retryable.RetryableDispatchRetryer;
import com.xforceplus.delivery.cloud.common.api.AjaxResult;
import com.xforceplus.delivery.cloud.common.util.ExceptionUtils;
import com.xforceplus.delivery.cloud.common.util.JsonUtils;
import com.xforceplus.delivery.cloud.common.util.SpringUtils;
import com.xforceplus.delivery.cloud.common.util.TraceUtils;
import com.xforceplus.delivery.cloud.gen.commons.entity.AopRetryableQueueEntity;
import com.xforceplus.delivery.cloud.gen.commons.service.IAopRetryableQueueService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.log.XxlJobLogger;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RetryableDispatchJobHandler {
    private static final Logger log = LoggerFactory.getLogger(RetryableDispatchJobHandler.class);
    @Autowired
    private RetryableDispatchRetryer retryableDispatchRetryer;
    @Autowired
    private IAopRetryableQueueService iAopRetryableQueueService;
    @Autowired
    private RetryableDispatchProperties retryableDispatchProperties;

    @XxlJob(value="doRetryableDispatch")
    public ReturnT<String> doRetryableDispatch(String args) {
        Long id = 0L;
        int pageNo = 1;
        AopRetryableJobarg aopRetryableJobarg = this.getJobarg(args);
        int maxPageCounter = aopRetryableJobarg.getTotalPages();
        while ((id = this.batchRetryableDispatch(aopRetryableJobarg, SpringUtils.getAppName(), id)) != null && (maxPageCounter == -1 || pageNo++ < maxPageCounter)) {
        }
        return IJobHandler.SUCCESS;
    }

    protected AopRetryableJobarg getJobarg(String args) {
        Integer totalPages;
        Integer perPageSize;
        log.debug("XXL-JOB, retryable dispatch queue job param - {}", (Object)args);
        AopRetryableJobarg aopRetryableJobarg = (AopRetryableJobarg)JsonUtils.fromJson((String)args, AopRetryableJobarg.class);
        Integer maxRetryCount = aopRetryableJobarg.getMaxRetryCount();
        if (maxRetryCount == null || maxRetryCount == 0) {
            aopRetryableJobarg.setMaxRetryCount(this.retryableDispatchProperties.getMaxRetryCount());
        }
        if ((perPageSize = aopRetryableJobarg.getPerPageSize()) == null || perPageSize == 0) {
            aopRetryableJobarg.setPerPageSize(this.retryableDispatchProperties.getPerPageSize());
        }
        if ((totalPages = aopRetryableJobarg.getTotalPages()) == null || totalPages == 0) {
            aopRetryableJobarg.setTotalPages(this.retryableDispatchProperties.getTotalPages());
        }
        return aopRetryableJobarg;
    }

    private Long batchRetryableDispatch(AopRetryableJobarg aopRetryableJobarg, String appName, Long id) {
        int perPageSize = aopRetryableJobarg.getPerPageSize();
        int maxRetryCount = aopRetryableJobarg.getMaxRetryCount();
        Page aopRetryableQueueEntityPage = (Page)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.iAopRetryableQueueService.lambdaQuery().eq(AopRetryableQueueEntity::getEvtname, (Object)aopRetryableJobarg.getEvtname())).eq(AopRetryableQueueEntity::getSvcname, (Object)appName)).lt(AopRetryableQueueEntity::getRetryCounter, (Object)maxRetryCount)).gt(AopRetryableQueueEntity::getId, (Object)id)).page((IPage)new Page(1L, (long)perPageSize));
        List records = aopRetryableQueueEntityPage.getRecords();
        log.debug("XXL-JOB, retryable dispatch queue batch query - {}/{}({})", new Object[]{records.size(), aopRetryableQueueEntityPage.getTotal(), perPageSize});
        records.stream().peek(rqe -> rqe.setLimitCounter(Integer.valueOf(maxRetryCount))).forEach(this::doRetryableDispatch);
        if (records.size() < perPageSize) {
            return null;
        }
        return records.stream().max(Comparator.comparing(AopRetryableQueueEntity::getId)).map(AopRetryableQueueEntity::getId).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRetryableDispatch(AopRetryableQueueEntity aopRetryableQueueEntity) {
        String evtname = aopRetryableQueueEntity.getEvtname();
        String keyword = aopRetryableQueueEntity.getKeyword();
        String traceId = aopRetryableQueueEntity.getTraceId();
        TraceUtils.setMdcTraceId((String)traceId);
        if (Thread.currentThread().isInterrupted()) {
            log.debug("XXL-JOB, [{}][{}]retryable dispatch queue interrupted - {}", new Object[]{traceId, evtname, keyword});
            XxlJobLogger.log((String)"[{}][{}]retryable dispatch queue interrupted - {}", (Object[])new Object[]{traceId, evtname, keyword});
            return;
        }
        try {
            XxlJobLogger.log((String)"[{}][{}]retryable dispatch queue starting - {}", (Object[])new Object[]{traceId, evtname, keyword});
            AjaxResult ajaxResult = this.retryableDispatchRetryer.doRetryableDispatch(aopRetryableQueueEntity);
            XxlJobLogger.log((String)"[{}][{}]retryable dispatch queue finished - {}", (Object[])new Object[]{traceId, evtname, JsonUtils.toJson((Object)ajaxResult)});
        }
        catch (Exception e) {
            log.warn("XXL-JOB, dispatch exception - {}", (Object)(evtname + ":" + keyword), (Object)e);
            XxlJobLogger.log((String)"[{}][{}]retryable dispatch queue exception - {}", (Object[])new Object[]{traceId, evtname, ExceptionUtils.toStringRootCauseStackTrace((Throwable)e)});
        }
        finally {
            TraceUtils.clsMdcTraceId();
        }
    }
}

