/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.delivery.cloud.auxiliary.retryable;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.xforceplus.delivery.cloud.auxiliary.properties.RetryableDispatchProperties;
import com.xforceplus.delivery.cloud.auxiliary.retryable.RetryableDispatcherBeanPostProcessor;
import com.xforceplus.delivery.cloud.common.api.AjaxResult;
import com.xforceplus.delivery.cloud.common.util.JsonUtils;
import com.xforceplus.delivery.cloud.common.util.SpringUtils;
import com.xforceplus.delivery.cloud.common.util.StringUtils;
import com.xforceplus.delivery.cloud.common.util.TraceUtils;
import com.xforceplus.delivery.cloud.gen.commons.entity.AopRetryableQueueEntity;
import com.xforceplus.delivery.cloud.gen.commons.service.IAopRetryableQueueService;
import java.io.Serializable;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RetryableDispatchRetryer {
    private static final Logger log = LoggerFactory.getLogger(RetryableDispatchRetryer.class);
    @Autowired
    private IAopRetryableQueueService iAopRetryableQueueService;
    @Autowired
    private RetryableDispatchProperties retryableDispatchProperties;
    @Autowired
    private RetryableDispatcherBeanPostProcessor retryableDispatcherBeanPostProcessor;

    public AjaxResult doRetryableDispatch(AopRetryableQueueEntity aopRetryableQueueEntity) {
        String evtname = aopRetryableQueueEntity.getEvtname();
        String invokeArgs = aopRetryableQueueEntity.getInvokeArgs();
        return this.doRetryableDispatch(() -> this.retryableDispatcherBeanPostProcessor.invokeForJson(evtname, invokeArgs), aopRetryableQueueEntity);
    }

    public AjaxResult doRetryableDispatch(String evtname, String keyword, Object ... invokeArgs) {
        log.trace("executing retryable dispatch evt={},key={}", (Object)evtname, (Object)keyword);
        AopRetryableQueueEntity aopRetryableQueueEntity = new AopRetryableQueueEntity();
        aopRetryableQueueEntity.setInvokeArgs(JsonUtils.toJson((Object)invokeArgs));
        aopRetryableQueueEntity.setRetryCounter(Integer.valueOf(0));
        aopRetryableQueueEntity.setEvtname(evtname);
        aopRetryableQueueEntity.setKeyword(StringUtils.toUpperCase((String)keyword));
        aopRetryableQueueEntity.setSvcname(SpringUtils.getAppName());
        TraceUtils.getTraceId().ifPresent(arg_0 -> ((AopRetryableQueueEntity)aopRetryableQueueEntity).setTraceId(arg_0));
        return this.doRetryableDispatch(() -> this.retryableDispatcherBeanPostProcessor.invokeMethod(evtname, invokeArgs), aopRetryableQueueEntity);
    }

    protected AjaxResult doRetryableDispatch(Supplier<AjaxResult> supplier, AopRetryableQueueEntity aopRetryableQueueEntity) {
        Long queueEntityId = aopRetryableQueueEntity.getId();
        String evtname = aopRetryableQueueEntity.getEvtname();
        String svcname = aopRetryableQueueEntity.getSvcname();
        String keyword = aopRetryableQueueEntity.getKeyword();
        AjaxResult ajaxResult = supplier.get();
        if (this.isRetryWith(ajaxResult)) {
            Integer retryCounter = aopRetryableQueueEntity.getRetryCounter();
            log.debug("retryable dispatch queue increasing: eq: evt={},svc={},key={}", new Object[]{evtname, svcname, keyword});
            aopRetryableQueueEntity.setRetryCounter(Integer.valueOf(retryCounter + 1));
            if (queueEntityId == null || queueEntityId == 0L) {
                this.iAopRetryableQueueService.saveOrUpdate((Object)aopRetryableQueueEntity, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AopRetryableQueueEntity::getEvtname, (Object)evtname)).eq(AopRetryableQueueEntity::getSvcname, (Object)svcname)).eq(AopRetryableQueueEntity::getKeyword, (Object)keyword));
            } else {
                this.iAopRetryableQueueService.updateById((Object)aopRetryableQueueEntity);
            }
        } else if (queueEntityId == null || queueEntityId == 0L) {
            log.debug("retryable dispatch queue clearing by eq: evt={},svc={},key={}", new Object[]{evtname, svcname, keyword});
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.iAopRetryableQueueService.lambdaUpdate().eq(AopRetryableQueueEntity::getEvtname, (Object)evtname)).eq(AopRetryableQueueEntity::getSvcname, (Object)svcname)).eq(AopRetryableQueueEntity::getKeyword, (Object)keyword)).remove();
        } else {
            log.debug("retryable dispatch queue clearing by id: {},eq: evt={},svc={},key={}", new Object[]{queueEntityId, evtname, svcname, keyword});
            this.iAopRetryableQueueService.removeById((Serializable)queueEntityId);
        }
        return ajaxResult;
    }

    protected boolean isRetryWith(AjaxResult ajaxResult) {
        Integer code = ajaxResult.getCode();
        Set<Integer> excludes = this.retryableDispatchProperties.getExcludes();
        log.debug("dispatch retry exclude [{}]{}", (Object)code, excludes);
        if (excludes.contains(code)) {
            return false;
        }
        Set<Integer> includes = this.retryableDispatchProperties.getIncludes();
        log.debug("dispatch retry include [{}]{}", (Object)code, includes);
        return includes.isEmpty() || includes.contains(code);
    }
}

