/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.delivery.cloud.auxiliary.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.delivery.cloud.auxiliary.domain.AopOperateRecord;
import com.xforceplus.delivery.cloud.auxiliary.service.AuxiliaryAopOperateRecordService;
import com.xforceplus.delivery.cloud.common.api.AjaxResult;
import com.xforceplus.delivery.cloud.common.api.ViewResult;
import com.xforceplus.delivery.cloud.common.properties.GlobalProperties;
import com.xforceplus.delivery.cloud.common.util.DateUtils;
import com.xforceplus.delivery.cloud.common.util.StringUtils;
import com.xforceplus.delivery.cloud.gen.commons.entity.AopOperateRecordEntity;
import com.xforceplus.delivery.cloud.gen.commons.service.IAopOperateRecordService;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Primary
public class AuxiliaryAopOperateRecordServiceImpl
implements AuxiliaryAopOperateRecordService {
    private static final Logger log = LoggerFactory.getLogger(AuxiliaryAopOperateRecordServiceImpl.class);
    @Autowired
    private GlobalProperties globalProperties;
    @Autowired
    private IAopOperateRecordService iAopOperateRecordService;

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean removeByWrapper(LambdaQueryWrapper<AopOperateRecordEntity> lambdaQuery) {
        return this.iAopOperateRecordService.remove(lambdaQuery);
    }

    @Override
    public AjaxResult removeByExample(AopOperateRecordEntity aopOperateRecord) {
        Long aopOperateRecordId = aopOperateRecord.getId();
        boolean affectedRows = aopOperateRecordId == null || aopOperateRecordId == 0L ? this.doBatchRemove(aopOperateRecord) : this.iAopOperateRecordService.removeById((Serializable)aopOperateRecordId);
        return ViewResult.success().data((Object)affectedRows);
    }

    private boolean doBatchRemove(AopOperateRecordEntity aopOperateRecord) {
        String[] aCleanTime;
        String cleanTime;
        String businessType = aopOperateRecord.getBusinessType();
        String businessKey = aopOperateRecord.getBusinessKey();
        log.debug("operate record clean starting: [{}]{}", (Object)businessType, (Object)businessKey);
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery(AopOperateRecordEntity.class);
        lambdaQuery.eq(AopOperateRecordEntity::getBusinessType, (Object)businessType);
        if (StringUtils.isNotBlank((CharSequence)businessKey)) {
            if (businessKey.contains("%")) {
                lambdaQuery.like(AopOperateRecordEntity::getBusinessKey, (Object)businessKey);
            } else {
                lambdaQuery.eq(AopOperateRecordEntity::getBusinessKey, (Object)businessKey);
            }
        }
        Optional.ofNullable(StringUtils.emptyToNull((CharSequence)aopOperateRecord.getKeyword())).ifPresent(keyword -> {
            if (keyword.contains("%")) {
                lambdaQuery.like(AopOperateRecordEntity::getKeyword, keyword);
            } else {
                lambdaQuery.eq(AopOperateRecordEntity::getKeyword, keyword);
            }
        });
        Optional.ofNullable(aopOperateRecord.getOperateState()).ifPresent(s -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)lambdaQuery.eq(AopOperateRecordEntity::getOperateState, s);
        });
        Optional.ofNullable(aopOperateRecord.getOperateType()).ifPresent(s -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)lambdaQuery.eq(AopOperateRecordEntity::getOperateType, s);
        });
        if (aopOperateRecord instanceof AopOperateRecord && StringUtils.isNotBlank((CharSequence)(cleanTime = ((AopOperateRecord)aopOperateRecord).getCleanTime())) && (aCleanTime = cleanTime.split("~")).length == 2) {
            lambdaQuery.between(AopOperateRecordEntity::getOperateTime, (Object)DateUtils.toLocalDateTime((String)aCleanTime[0]), (Object)DateUtils.toLocalDateTime((String)aCleanTime[1]));
        }
        return this.batchDelete((LambdaQueryWrapper<AopOperateRecordEntity>)lambdaQuery) > 0;
    }

    @Override
    public AjaxResult doCleanHistory(int retainDays) {
        log.debug("operate record clean history retain days => {}", (Object)retainDays);
        this.iAopOperateRecordService.query().select(new String[]{"min(operate_time) as operateTime"}).oneOpt().map(AopOperateRecordEntity::getOperateTime).ifPresent(operateTime -> {
            LocalDate sLocalDate = operateTime.toLocalDate();
            LocalDate eLocalDate = LocalDate.now().minusDays(retainDays + 1);
            log.debug("operate record clean history clean scope => {}~{}", (Object)sLocalDate, (Object)eLocalDate);
            while (sLocalDate.isBefore(eLocalDate)) {
                this.batchDelete(sLocalDate, sLocalDate.plusDays(1L));
                sLocalDate = sLocalDate.plusDays(1L);
            }
        });
        log.debug("operate record clean history game over");
        return ViewResult.success();
    }

    private int batchDelete(LocalDate sLocalDate, LocalDate eLocalDate) {
        log.debug("operate record deleting => {}~{}", (Object)sLocalDate, (Object)eLocalDate);
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery(AopOperateRecordEntity.class);
        lambdaQuery.between(AopOperateRecordEntity::getOperateTime, (Object)sLocalDate, (Object)eLocalDate);
        return this.batchDelete((LambdaQueryWrapper<AopOperateRecordEntity>)lambdaQuery);
    }

    private int batchDelete(LambdaQueryWrapper<AopOperateRecordEntity> lambdaQuery) {
        int affectedRows;
        int totalRows = 0;
        lambdaQuery.last(" limit " + this.globalProperties.getRemoveBatchSize());
        do {
            log.debug("operate record batch clearing: {}", lambdaQuery);
            affectedRows = this.iAopOperateRecordService.getBaseMapper().delete(lambdaQuery);
            totalRows += affectedRows;
            log.debug("operate record batch cleaned affected: {}", (Object)affectedRows);
        } while (affectedRows > 0);
        log.debug("operate record batch cleaned finished => {}", (Object)totalRows);
        return totalRows;
    }
}

