/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.delivery.cloud.discovery.component;

import cn.hutool.core.util.ObjectUtil;
import com.xforceplus.delivery.cloud.common.client.ExternalRestClient;
import com.xforceplus.delivery.cloud.common.client.IRestClient;
import com.xforceplus.delivery.cloud.common.component.BroadcastMessagePublisher;
import com.xforceplus.delivery.cloud.common.properties.ClientSecretProperties;
import com.xforceplus.delivery.cloud.common.properties.GlobalProperties;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Primary
@Component
public class NacosBroadcastMessagePublisher
implements BroadcastMessagePublisher {
    private static final Logger log = LoggerFactory.getLogger(NacosBroadcastMessagePublisher.class);
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired
    private GlobalProperties globalProperties;
    @Autowired
    private ExternalRestClient externalRestClient;

    public Stream<UriComponentsBuilder> getServerList(String destination) {
        List services = this.discoveryClient.getServices();
        if (ObjectUtil.isEmpty((Object)services)) {
            return Stream.empty();
        }
        return services.parallelStream().map(arg_0 -> ((DiscoveryClient)this.discoveryClient).getInstances(arg_0)).flatMap(Collection::stream).map(inst -> UriComponentsBuilder.fromUri((URI)inst.getUri()));
    }

    public ClientSecretProperties getSecretProperties() {
        return this.globalProperties.getOauth();
    }

    public IRestClient getRestClient() {
        return this.externalRestClient;
    }
}

