/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.delivery.cloud.discovery.component;

import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.xforceplus.delivery.cloud.common.cache.CacheRefreshEvent;
import com.xforceplus.delivery.cloud.common.util.StringUtils;
import com.xforceplus.delivery.cloud.discovery.component.NacosCacheRefreshHandler;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class NacosCacheRefreshListener {
    private static final Logger log = LoggerFactory.getLogger(NacosCacheRefreshListener.class);
    private final ConfigService configService;
    private final NacosConfigProperties nacosConfigProperties;
    private Map<String, NacosCacheRefreshHandler> cacheRefreshHandlerMap;

    public NacosCacheRefreshListener(NacosConfigManager nacosConfigManager) {
        this.configService = nacosConfigManager.getConfigService();
        this.nacosConfigProperties = nacosConfigManager.getNacosConfigProperties();
        this.cacheRefreshHandlerMap = new HashMap<String, NacosCacheRefreshHandler>();
    }

    public void register(String dataId, String prop, NacosCacheRefreshHandler handler) {
        this.cacheRefreshHandlerMap.put(dataId + "$" + prop, handler);
    }

    @EventListener(value={CacheRefreshEvent.class})
    public void handleOAuth2Perms(CacheRefreshEvent cacheRefreshEvent) {
        String handlerKey = cacheRefreshEvent.getDataId() + "$" + cacheRefreshEvent.getProp();
        Optional.ofNullable(this.cacheRefreshHandlerMap.get(handlerKey)).ifPresent(handler -> this.publishConfigProperties(cacheRefreshEvent, (NacosCacheRefreshHandler)handler));
    }

    private void publishConfigProperties(CacheRefreshEvent cacheRefreshEvent, NacosCacheRefreshHandler cacheRefreshHandler) {
        Properties properties = cacheRefreshHandler.update(this.getConfigProperties(cacheRefreshEvent), cacheRefreshEvent);
        String text = properties.entrySet().stream().map(e -> e.getKey() + "=" + e.getValue()).collect(Collectors.joining("\n", "", ""));
        try {
            log.debug("nacos config refresh publish to server: {}", (Object)text);
            boolean bool = this.configService.publishConfig(cacheRefreshEvent.getDataId(), "CACHE_GROUP", text);
            log.debug("nacos config refresh publish result: {}", (Object)bool);
        }
        catch (NacosException e2) {
            log.warn("nacos config refresh publish to server fail - {}", (Object)text, (Object)e2);
        }
    }

    private Properties getConfigProperties(CacheRefreshEvent cacheRefreshEvent) {
        Properties properties = new Properties();
        String dataId = cacheRefreshEvent.getDataId();
        try {
            String config = this.configService.getConfig(dataId, "CACHE_GROUP", (long)this.nacosConfigProperties.getTimeout());
            log.debug("nacos config refresh get server result: {}", (Object)config);
            if (StringUtils.isNotBlank((CharSequence)config)) {
                try {
                    properties.load(new StringReader(config));
                    log.debug("nacos config refresh loaded to props: {}", (Object)properties);
                }
                catch (IOException e) {
                    log.warn("nacos config refresh load to props fail for {}", (Object)dataId, (Object)e);
                }
            }
        }
        catch (NacosException e) {
            log.warn("nacos config refresh get fail for {}", (Object)dataId, (Object)e);
        }
        return properties;
    }
}

