/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.delivery.cloud.discovery.component;

import cn.hutool.core.util.NumberUtil;
import com.xforceplus.delivery.cloud.common.api.Company;
import com.xforceplus.delivery.cloud.common.api.ViewResult;
import com.xforceplus.delivery.cloud.common.cache.CompanyLoader;
import com.xforceplus.delivery.cloud.common.client.InternalRestClient;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public class NacosCompanyLoader
implements CompanyLoader {
    @Autowired
    private InternalRestClient webClient;

    public Optional<Company> getByTaxNo(String taxNo) {
        Company company = new Company();
        company.setCompanyTaxNo(taxNo);
        return this.getRemoteCompany("/queryByTaxNo", company);
    }

    public Optional<Company> getByCompanyId(String companyId) {
        Company company = new Company();
        company.setId(Integer.valueOf(NumberUtil.parseInt((String)companyId)));
        return this.getRemoteCompany("/queryById", company);
    }

    private Optional<Company> getRemoteCompany(String path, Company company) {
        String url = "http://system/system/company" + path;
        ViewResult viewResult = this.webClient.postForObject(url, (Object)company, Company.class, new Object[0]);
        return Optional.ofNullable(viewResult.getData());
    }
}

