/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.delivery.cloud.discovery.component;

import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.config.annotation.NacosConfigurationProperties;
import com.xforceplus.delivery.cloud.common.api.DataDict;
import com.xforceplus.delivery.cloud.common.cache.CacheRefreshEvent;
import com.xforceplus.delivery.cloud.common.cache.DataDictLoader;
import com.xforceplus.delivery.cloud.discovery.component.NacosCacheRefreshListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@NacosConfigurationProperties(autoRefreshed=true, type=ConfigType.PROPERTIES, dataId="dict.properties", groupId="CACHE_GROUP", prefix="delivery.cloud.cache.dict")
@ConfigurationProperties(prefix="delivery.cloud.cache.dict", ignoreInvalidFields=true)
public class NacosDictCacheLoader
implements DataDictLoader,
InitializingBean {
    @Autowired
    private NacosCacheRefreshListener nacosCacheRefreshListener;
    private Map<String, List<DataDict>> items;

    public List<DataDict> getDictItems(String dictType) {
        return this.items.getOrDefault(dictType, Collections.emptyList());
    }

    public void afterPropertiesSet() throws Exception {
        this.nacosCacheRefreshListener.register("dict.properties", "items", this::updateProperties);
    }

    private Properties updateProperties(Properties properties, CacheRefreshEvent cacheRefreshEvent) {
        return cacheRefreshEvent.refreshProps(properties, "delivery.cloud.cache.dict");
    }

    public Map<String, List<DataDict>> getItems() {
        return this.items;
    }

    public void setItems(Map<String, List<DataDict>> items) {
        this.items = items;
    }
}

