/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.delivery.cloud.discovery.component;

import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.config.annotation.NacosConfigurationProperties;
import com.xforceplus.delivery.cloud.common.cache.CacheRefreshEvent;
import com.xforceplus.delivery.cloud.discovery.component.NacosCacheRefreshListener;
import com.xforceplus.delivery.cloud.secure.component.RolePermsLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@NacosConfigurationProperties(autoRefreshed=true, type=ConfigType.PROPERTIES, dataId="roles.properties", groupId="CACHE_GROUP", prefix="delivery.cloud.cache.roles")
@ConfigurationProperties(prefix="delivery.cloud.cache.roles", ignoreInvalidFields=true)
public class NacosRolePermsLoader
implements RolePermsLoader,
InitializingBean {
    @Autowired
    private NacosCacheRefreshListener nacosCacheRefreshListener;
    private Map<String, Collection<String>> perms;

    public Collection<String> role2Perms(String roleId) {
        return this.perms.getOrDefault(roleId, Collections.emptyList());
    }

    public void afterPropertiesSet() throws Exception {
        this.nacosCacheRefreshListener.register("roles.properties", "perms", this::updateProperties);
    }

    private Properties updateProperties(Properties properties, CacheRefreshEvent cacheRefreshEvent) {
        return cacheRefreshEvent.refreshProps(properties, "delivery.cloud.cache.roles");
    }

    public Map<String, Collection<String>> getPerms() {
        return this.perms;
    }

    public void setPerms(Map<String, Collection<String>> perms) {
        this.perms = perms;
    }
}

