/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.delivery.cloud.monomer.component;

import com.xforceplus.delivery.cloud.common.client.ExternalRestClient;
import com.xforceplus.delivery.cloud.common.client.IRestClient;
import com.xforceplus.delivery.cloud.common.component.BroadcastMessage;
import com.xforceplus.delivery.cloud.common.component.BroadcastMessagePublisher;
import com.xforceplus.delivery.cloud.common.properties.ClientSecretProperties;
import com.xforceplus.delivery.cloud.common.properties.GlobalProperties;
import com.xforceplus.delivery.cloud.common.util.IPUtils;
import com.xforceplus.delivery.cloud.common.util.SpringUtils;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component
@ConfigurationProperties(prefix="delivery.cloud.monomer.broadcast")
public class MonomerBroadcastMessagePublisher
implements BroadcastMessagePublisher,
InitializingBean {
    private List<String> instances;
    @Autowired
    private GlobalProperties globalProperties;
    @Autowired
    private ExternalRestClient externalRestClient;

    public void afterPropertiesSet() throws Exception {
        if (this.instances == null) {
            this.instances = Collections.singletonList(IPUtils.getLocalIp() + ":" + SpringUtils.getAppPort());
        }
    }

    private UriComponentsBuilder buildUriComponent(String authority) {
        String[] authorities = authority.split(":");
        return UriComponentsBuilder.newInstance().scheme("http").host(authorities[0]).port(authorities[1]);
    }

    public void change(BroadcastMessage broadcastMessage, String destination) {
    }

    public void delete(BroadcastMessage broadcastMessage, String destination) {
    }

    public ClientSecretProperties getSecretProperties() {
        return this.globalProperties.getOauth();
    }

    public IRestClient getRestClient() {
        return this.externalRestClient;
    }

    public List<String> getInstances() {
        return this.instances;
    }

    public void setInstances(List<String> instances) {
        this.instances = instances;
    }
}

