/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.delivery.cloud.monomer.component;

import com.xforceplus.delivery.cloud.common.api.DataDict;
import com.xforceplus.delivery.cloud.common.component.DataDictLoader;
import com.xforceplus.delivery.cloud.common.component.LoadingCacheLoader;
import com.xforceplus.delivery.cloud.common.util.BeanUtils;
import com.xforceplus.delivery.cloud.system.service.IDictService;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MonomerDictCacheLoader
extends LoadingCacheLoader<List<DataDict>>
implements DataDictLoader,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MonomerDictCacheLoader.class);
    @Autowired
    private IDictService iDictService;

    public MonomerDictCacheLoader() {
        super(10L, TimeUnit.MINUTES, 36, 300);
    }

    public void afterPropertiesSet() throws Exception {
        this.build(typeCode -> this.iDictService.getDictItems(typeCode).stream().map(dict -> BeanUtils.copyObject((Object)dict, DataDict.class)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    public List<DataDict> getDictItems(String dictType) {
        return (List)this.get(dictType);
    }
}

