/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.delivery.cloud.monomer.limiter;

import cn.hutool.core.collection.CollectionUtil;
import com.google.common.base.Joiner;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.UrlPathHelper;

@Component
@ConfigurationProperties(value="delivery.cloud.monomer.rate-limiter")
@ConditionalOnProperty(prefix="delivery.cloud.monomer.rate-limiter", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class SmoothBurstyLimiterInterceptor
extends HandlerInterceptorAdapter
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(SmoothBurstyLimiterInterceptor.class);
    private Integer permitsPerSecond = 100;
    private Map<String, Integer> urlPatternMap;
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private Map<PatternsRequestCondition, RateLimiter> urlRateMap;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.urlRateMap != null && !this.urlRateMap.isEmpty()) {
            String lookupPath = this.urlPathHelper.getLookupPathForRequest(request);
            for (PatternsRequestCondition patternsRequestCondition : this.urlRateMap.keySet()) {
                List matchingPatterns = patternsRequestCondition.getMatchingPatterns(lookupPath);
                if (CollectionUtil.isEmpty((Collection)matchingPatterns)) continue;
                log.trace("\u8bf7\u6c42{}\u6267\u884ctryAcquire({})", (Object)lookupPath, (Object)Joiner.on((String)",").join((Iterable)patternsRequestCondition.getPatterns()));
                if (this.urlRateMap.get(patternsRequestCondition).tryAcquire()) {
                    log.trace("\u8bf7\u6c42{}\u5339\u914d\u5230\u9650\u6d41\u5668\u4ee4\u724c", (Object)lookupPath);
                    continue;
                }
                log.trace("\u8bf7\u6c42{}\u8d85\u8fc7\u9650\u6d41\u5668\u901f\u7387", (Object)lookupPath);
                response.setStatus(HttpStatus.ACCEPTED.value());
                return false;
            }
        }
        return true;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (RequestMappingHandlerMapping.class.isAssignableFrom(bean.getClass())) {
            if (this.urlRateMap == null) {
                this.urlRateMap = new ConcurrentHashMap<PatternsRequestCondition, RateLimiter>();
            }
            log.info("we get all the controllers's methods and assign it to urlRateMap");
            RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)bean;
            Map handlerMethods = requestMappingHandlerMapping.getHandlerMethods();
            for (RequestMappingInfo rmi : handlerMethods.keySet()) {
                this.urlRateMap.put(rmi.getPatternsCondition(), RateLimiter.create((double)this.permitsPerSecond.intValue()));
            }
            if (this.urlPatternMap != null) {
                this.urlPatternMap.forEach((urlPattern, permitsPerSecond) -> this.urlRateMap.put(new PatternsRequestCondition(new String[]{urlPattern}), RateLimiter.create((double)permitsPerSecond.intValue())));
            }
        }
        return bean;
    }

    public void setPermitsPerSecond(Integer permitsPerSecond) {
        this.permitsPerSecond = permitsPerSecond;
    }

    public void setUrlPatternMap(Map<String, Integer> urlPatternMap) {
        this.urlPatternMap = urlPatternMap;
    }
}

