package com.xforceplus.delivery.cloud.monomer.component;

import com.xforceplus.delivery.cloud.common.client.ExternalRestClient;
import com.xforceplus.delivery.cloud.common.client.IRestClient;
import com.xforceplus.delivery.cloud.common.component.BroadcastMessagePublisher;
import com.xforceplus.delivery.cloud.common.properties.ClientSecretProperties;
import com.xforceplus.delivery.cloud.common.properties.GlobalProperties;
import com.xforceplus.delivery.cloud.common.util.IPUtils;
import com.xforceplus.delivery.cloud.common.util.SpringUtils;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

/**
 * 高于生活，源于生活
 * MonomerBroadcastMessagePublisher
 *
 * @Author: Hanyongjie
 * @CreateDate: 2020-11-06 22:11
 * @Version: 1.0
 */
@Component
@ConfigurationProperties(prefix = "delivery.cloud.monomer.broadcast")
public class MonomerBroadcastMessagePublisher implements BroadcastMessagePublisher, InitializingBean {

    @Getter
    @Setter
    private List<String> instances;

    @Autowired
    private GlobalProperties globalProperties;

    @Autowired
    private ExternalRestClient externalRestClient;

    /**
     * Invoked by the containing {@code BeanFactory} after it has set all bean properties and satisfied
     *
     * @throws Exception in the event of misconfiguration (such as failure to set an
     *                   essential property) or if initialization fails for any other reason
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.instances == null) {
            this.instances = Collections.singletonList(IPUtils.getLocalIp() + ":" + SpringUtils.getAppPort());
        }
    }

    /**
     * 构建URL
     *
     * @param authority
     * @return
     */
    private UriComponentsBuilder buildUriComponent(String authority) {
        final String[] authorities = authority.split(":");
        return UriComponentsBuilder.newInstance().scheme("http").host(authorities[0]).port(authorities[1]);
    }

    /**
     * 获得服务器列表
     *
     * @param destination
     * @return
     */
    @Override
    public Stream<UriComponentsBuilder> getServerList(String destination) {
        return this.instances.parallelStream().map(this::buildUriComponent);
    }

    @Override
    public ClientSecretProperties getSecretProperties() {
        return this.globalProperties.getOauth();
    }

    @Override
    public IRestClient getRestClient() {
        return this.externalRestClient;
    }

}