package com.xforceplus.delivery.cloud.monomer.component;

import com.xforceplus.delivery.cloud.common.api.DataDict;
import com.xforceplus.delivery.cloud.common.cache.DataDictLoader;
import com.xforceplus.delivery.cloud.common.cache.LoadingCacheLoader;
import com.xforceplus.delivery.cloud.common.util.BeanUtils;
import com.xforceplus.delivery.cloud.system.service.IDictService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 数据字典缓存10分钟自动刷新
 *
 * @vlog: 高于生活，源于生活
 * @Author: Hanyongjie
 * @CreateDate: 2020-08-31 16:41
 * @Version: 1.0
 */
@Slf4j
@Component
public class MonomerDictCacheLoader extends LoadingCacheLoader<List<DataDict>> implements DataDictLoader, InitializingBean {

    @Autowired
    private IDictService iDictService;

    public MonomerDictCacheLoader() {
        super(10, TimeUnit.MINUTES, 36, 300);
    }

    /**
     * Invoked by the containing {@code BeanFactory} after it has set all bean properties and satisfied
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        // 从数据库加载
        this.build(typeCode -> this.iDictService.getDictItems(typeCode).stream()
                .map(dict -> BeanUtils.copyObject(dict, DataDict.class))
                .filter(Optional::isPresent)
                .map(Optional::get)
                .collect(Collectors.toList()));
    }

    @Override
    public List<DataDict> getDictItems(String dictType) {
        return this.get(dictType); // 从缓存加载
    }

}