package com.xforceplus.delivery.cloud.monomer.component;

import cn.hutool.core.util.NumberUtil;
import com.xforceplus.delivery.cloud.common.cache.LoadingCacheLoader;
import com.xforceplus.delivery.cloud.permission.service.IRoleService;
import com.xforceplus.delivery.cloud.secure.component.RolePermsLoader;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.concurrent.TimeUnit;

/**
 * 角色权限缓存10分钟刷新
 *
 * @Author: Hanyongjie
 * @CreateDate: 2020-10-25 16:34
 * @Version: 1.0
 */
@Slf4j
@Component
public class MonomerRolePermsLoader extends LoadingCacheLoader<Collection<String>> implements RolePermsLoader, InitializingBean {

    @Autowired
    private IRoleService iRoleService;

    public MonomerRolePermsLoader() {
        super(10, TimeUnit.MINUTES, 6, 30);
    }

    /**
     * Invoked by the containing {@code BeanFactory} after it has set all bean properties and satisfied
     */
    @Override
    public void afterPropertiesSet() throws Exception {// 从数据库加载
        this.build(roleId -> this.iRoleService.getRolePerms(NumberUtil.parseInt(roleId)));
    }

    @Override
    public Collection<String> role2Perms(String roleId) {
        return this.get(roleId); // 从缓存加载
    }

}
