package com.xforceplus.delivery.cloud.monomer.configuration;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @vlog: 高于生活，源于生活
 * @Desc: CorsFilter过滤器
 * @Author: Hanyongjie
 * @CreateDate: 2020-07-12 01:25
 * @Version: 1.0
 */
@Setter
@Getter
@Configuration
@ConfigurationProperties(prefix = "delivery.cloud.webmvc.cors.allowed")
public class MonomerWebMvcConfig implements WebMvcConfigurer {

    private String pathPattern = "/**";

    private String[] origins = {"*"};

    private String[] headers = {"*"};

    private String[] methods = {"POST", "GET", "PUT", "OPTIONS", "DELETE"};

    private long maxAge = 3600L;

    @Override
    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping(this.pathPattern)
                .allowedOrigins(this.origins)
                .allowedHeaders(this.headers)
                .allowedMethods(this.methods)
                .allowCredentials(true)
                .maxAge(this.maxAge);
    }

}