/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.auth;

import com.alibaba.csp.sentinel.dashboard.auth.AuthAction;
import com.alibaba.csp.sentinel.dashboard.auth.AuthService;
import com.alibaba.csp.sentinel.dashboard.domain.Result;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class AuthorizationInterceptor
implements HandlerInterceptor {
    @Autowired
    private AuthService<HttpServletRequest> authService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Method method;
        AuthAction authAction;
        if (handler.getClass().isAssignableFrom(HandlerMethod.class) && (authAction = (method = ((HandlerMethod)handler).getMethod()).getAnnotation(AuthAction.class)) != null) {
            AuthService.AuthUser authUser = this.authService.getAuthUser(request);
            if (authUser == null) {
                this.responseNoPrivilegeMsg(response, authAction.message());
                return false;
            }
            String target = request.getParameter(authAction.targetName());
            if (!authUser.authTarget(target, authAction.value())) {
                this.responseNoPrivilegeMsg(response, authAction.message());
                return false;
            }
        }
        return true;
    }

    private void responseNoPrivilegeMsg(HttpServletResponse response, String message) throws IOException {
        Result result = Result.ofFail(-1, message);
        response.addHeader("Content-Type", "application/json;charset=UTF-8");
        response.getOutputStream().write(JSON.toJSONBytes(result, (SerializerFeature[])new SerializerFeature[0]));
    }
}

