/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.auth;

import com.alibaba.csp.sentinel.dashboard.auth.AuthService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component
@Primary
@ConditionalOnProperty(name={"auth.enabled"}, matchIfMissing=true)
public class SimpleWebAuthServiceImpl
implements AuthService<HttpServletRequest> {
    public static final String WEB_SESSION_KEY = "session_sentinel_admin";

    @Override
    public AuthService.AuthUser getAuthUser(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Object sentinelUserObj = session.getAttribute(WEB_SESSION_KEY);
        if (sentinelUserObj != null && sentinelUserObj instanceof AuthService.AuthUser) {
            return (AuthService.AuthUser)sentinelUserObj;
        }
        return null;
    }

    public static final class SimpleWebAuthUserImpl
    implements AuthService.AuthUser {
        private String username;

        public SimpleWebAuthUserImpl(String username) {
            this.username = username;
        }

        @Override
        public boolean authTarget(String target, AuthService.PrivilegeType privilegeType) {
            return true;
        }

        @Override
        public boolean isSuperUser() {
            return true;
        }

        @Override
        public String getNickName() {
            return this.username;
        }

        @Override
        public String getLoginName() {
            return this.username;
        }

        @Override
        public String getId() {
            return this.username;
        }
    }
}

