/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.client;

import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayFlowRule;
import com.alibaba.csp.sentinel.command.vo.NodeVo;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.dashboard.client.CommandFailedException;
import com.alibaba.csp.sentinel.dashboard.client.CommandNotFoundException;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.SentinelVersion;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.gateway.ApiDefinitionEntity;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.gateway.GatewayFlowRuleEntity;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.rule.AbstractRuleEntity;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.rule.AuthorityRuleEntity;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.rule.DegradeRuleEntity;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.rule.FlowRuleEntity;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.rule.ParamFlowRuleEntity;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.rule.RuleEntity;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.rule.SystemRuleEntity;
import com.alibaba.csp.sentinel.dashboard.discovery.AppManagement;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.ClusterClientInfoVO;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.config.ClusterClientConfig;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.config.ServerFlowConfig;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.config.ServerTransportConfig;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.state.ClusterServerStateVO;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.state.ClusterStateSimpleEntity;
import com.alibaba.csp.sentinel.dashboard.util.AsyncUtils;
import com.alibaba.csp.sentinel.dashboard.util.VersionUtils;
import com.alibaba.csp.sentinel.slots.block.Rule;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class SentinelApiClient {
    private static Logger logger = LoggerFactory.getLogger(SentinelApiClient.class);
    private static final Charset DEFAULT_CHARSET = Charset.forName(SentinelConfig.charset());
    private static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HTTP_HEADER_CONTENT_TYPE_URLENCODED = ContentType.create((String)"application/x-www-form-urlencoded").toString();
    private static final String RESOURCE_URL_PATH = "jsonTree";
    private static final String CLUSTER_NODE_PATH = "clusterNode";
    private static final String GET_RULES_PATH = "getRules";
    private static final String SET_RULES_PATH = "setRules";
    private static final String GET_PARAM_RULE_PATH = "getParamFlowRules";
    private static final String SET_PARAM_RULE_PATH = "setParamFlowRules";
    private static final String FETCH_CLUSTER_MODE_PATH = "getClusterMode";
    private static final String MODIFY_CLUSTER_MODE_PATH = "setClusterMode";
    private static final String FETCH_CLUSTER_CLIENT_CONFIG_PATH = "cluster/client/fetchConfig";
    private static final String MODIFY_CLUSTER_CLIENT_CONFIG_PATH = "cluster/client/modifyConfig";
    private static final String FETCH_CLUSTER_SERVER_BASIC_INFO_PATH = "cluster/server/info";
    private static final String MODIFY_CLUSTER_SERVER_TRANSPORT_CONFIG_PATH = "cluster/server/modifyTransportConfig";
    private static final String MODIFY_CLUSTER_SERVER_FLOW_CONFIG_PATH = "cluster/server/modifyFlowConfig";
    private static final String MODIFY_CLUSTER_SERVER_NAMESPACE_SET_PATH = "cluster/server/modifyNamespaceSet";
    private static final String FETCH_GATEWAY_API_PATH = "gateway/getApiDefinitions";
    private static final String MODIFY_GATEWAY_API_PATH = "gateway/updateApiDefinitions";
    private static final String FETCH_GATEWAY_FLOW_RULE_PATH = "gateway/getRules";
    private static final String MODIFY_GATEWAY_FLOW_RULE_PATH = "gateway/updateRules";
    private static final String FLOW_RULE_TYPE = "flow";
    private static final String DEGRADE_RULE_TYPE = "degrade";
    private static final String SYSTEM_RULE_TYPE = "system";
    private static final String AUTHORITY_TYPE = "authority";
    private CloseableHttpAsyncClient httpClient;
    private static final SentinelVersion version160 = new SentinelVersion(1, 6, 0);
    private static final SentinelVersion version171 = new SentinelVersion(1, 7, 1);
    @Autowired
    private AppManagement appManagement;

    public SentinelApiClient() {
        IOReactorConfig ioConfig = IOReactorConfig.custom().setConnectTimeout(3000).setSoTimeout(10000).setIoThreadCount(Runtime.getRuntime().availableProcessors() * 2).build();
        this.httpClient = HttpAsyncClients.custom().setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){

            protected boolean isRedirectable(String method) {
                return false;
            }
        }).setMaxConnTotal(4000).setMaxConnPerRoute(1000).setDefaultIOReactorConfig(ioConfig).build();
        this.httpClient.start();
    }

    private boolean isSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    private boolean isCommandNotFound(int statusCode, String body) {
        return statusCode == 400 && StringUtil.isNotEmpty((String)body) && body.contains("Unknown command");
    }

    protected boolean isSupportPost(String app, String ip, int port) {
        return StringUtil.isNotEmpty((String)app) && Optional.ofNullable(this.appManagement.getDetailApp(app)).flatMap(e -> e.getMachine(ip, port)).flatMap(m -> VersionUtils.parseVersion(m.getVersion()).map(v -> v.greaterOrEqual(version160))).orElse(false) != false;
    }

    protected boolean isSupportEnhancedContentType(String app, String ip, int port) {
        return StringUtil.isNotEmpty((String)app) && Optional.ofNullable(this.appManagement.getDetailApp(app)).flatMap(e -> e.getMachine(ip, port)).flatMap(m -> VersionUtils.parseVersion(m.getVersion()).map(v -> v.greaterOrEqual(version171))).orElse(false) != false;
    }

    private StringBuilder queryString(Map<String, String> params) {
        StringBuilder queryStringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (StringUtil.isEmpty((String)entry.getValue())) continue;
            String name = this.urlEncode(entry.getKey());
            String value = this.urlEncode(entry.getValue());
            if (name == null || value == null) continue;
            if (queryStringBuilder.length() > 0) {
                queryStringBuilder.append('&');
            }
            queryStringBuilder.append(name).append('=').append(value);
        }
        return queryStringBuilder;
    }

    protected static HttpUriRequest postRequest(String url, Map<String, String> params, boolean supportEnhancedContentType) {
        HttpPost httpPost = new HttpPost(url);
        if (params != null && params.size() > 0) {
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, String> entry : params.entrySet()) {
                list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(list, Consts.UTF_8));
            if (!supportEnhancedContentType) {
                httpPost.setHeader(HTTP_HEADER_CONTENT_TYPE, HTTP_HEADER_CONTENT_TYPE_URLENCODED);
            }
        }
        return httpPost;
    }

    private String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, DEFAULT_CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            logger.info("encode string error: {}", (Object)str, (Object)e);
            return null;
        }
    }

    private String getBody(HttpResponse response) throws Exception {
        Charset charset = null;
        try {
            String contentTypeStr = response.getFirstHeader(HTTP_HEADER_CONTENT_TYPE).getValue();
            if (StringUtil.isNotEmpty((String)contentTypeStr)) {
                ContentType contentType = ContentType.parse((String)contentTypeStr);
                charset = contentType.getCharset();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)(charset != null ? charset : DEFAULT_CHARSET));
    }

    private CompletableFuture<String> executeCommand(String ip, int port, String api, boolean useHttpPost) {
        return this.executeCommand(ip, port, api, null, useHttpPost);
    }

    private CompletableFuture<String> executeCommand(String ip, int port, String api, Map<String, String> params, boolean useHttpPost) {
        return this.executeCommand(null, ip, port, api, params, useHttpPost);
    }

    private CompletableFuture<String> executeCommand(String app, String ip, int port, String api, Map<String, String> params, boolean useHttpPost) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        if (StringUtil.isBlank((String)ip) || StringUtil.isBlank((String)api)) {
            future.completeExceptionally(new IllegalArgumentException("Bad URL or command name"));
            return future;
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append("http://");
        urlBuilder.append(ip).append(':').append(port).append('/').append(api);
        if (params == null) {
            params = Collections.emptyMap();
        }
        if (!useHttpPost || !this.isSupportPost(app, ip, port)) {
            if (!params.isEmpty()) {
                if (urlBuilder.indexOf("?") == -1) {
                    urlBuilder.append('?');
                } else {
                    urlBuilder.append('&');
                }
                urlBuilder.append((CharSequence)this.queryString(params));
            }
            return this.executeCommand((HttpUriRequest)new HttpGet(urlBuilder.toString()));
        }
        return this.executeCommand(SentinelApiClient.postRequest(urlBuilder.toString(), params, this.isSupportEnhancedContentType(app, ip, port)));
    }

    private CompletableFuture<String> executeCommand(final HttpUriRequest request) {
        final CompletableFuture<String> future = new CompletableFuture<String>();
        this.httpClient.execute(request, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse response) {
                int statusCode = response.getStatusLine().getStatusCode();
                try {
                    String value = SentinelApiClient.this.getBody(response);
                    if (SentinelApiClient.this.isSuccess(statusCode)) {
                        future.complete(value);
                    } else if (SentinelApiClient.this.isCommandNotFound(statusCode, value)) {
                        future.completeExceptionally(new CommandNotFoundException(request.getURI().getPath()));
                    } else {
                        future.completeExceptionally(new CommandFailedException(value));
                    }
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                    logger.error("HTTP request failed: {}", (Object)request.getURI().toString(), (Object)ex);
                }
            }

            public void failed(Exception ex) {
                future.completeExceptionally(ex);
                logger.error("HTTP request failed: {}", (Object)request.getURI().toString(), (Object)ex);
            }

            public void cancelled() {
                future.complete(null);
            }
        });
        return future;
    }

    public void close() throws Exception {
        this.httpClient.close();
    }

    @Nullable
    private <T> CompletableFuture<List<T>> fetchItemsAsync(String ip, int port, String api, String type, Class<T> ruleType) {
        AssertUtil.notEmpty((String)ip, (String)"Bad machine IP");
        AssertUtil.isTrue((port > 0 ? 1 : 0) != 0, (String)"Bad machine port");
        HashMap<String, String> params = null;
        if (StringUtil.isNotEmpty((String)type)) {
            params = new HashMap<String, String>(1);
            params.put("type", type);
        }
        return this.executeCommand(ip, port, api, params, false).thenApply(json -> JSON.parseArray((String)json, (Class)ruleType));
    }

    @Nullable
    private <T> List<T> fetchItems(String ip, int port, String api, String type, Class<T> ruleType) {
        try {
            AssertUtil.notEmpty((String)ip, (String)"Bad machine IP");
            AssertUtil.isTrue((port > 0 ? 1 : 0) != 0, (String)"Bad machine port");
            HashMap<String, String> params = null;
            if (StringUtil.isNotEmpty((String)type)) {
                params = new HashMap<String, String>(1);
                params.put("type", type);
            }
            return this.fetchItemsAsync(ip, port, api, type, ruleType).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Error when fetching items from api: {} -> {}", new Object[]{api, type, e});
            return null;
        }
        catch (Exception e) {
            logger.error("Error when fetching items: {} -> {}", new Object[]{api, type, e});
            return null;
        }
    }

    private <T extends Rule> List<T> fetchRules(String ip, int port, String type, Class<T> ruleType) {
        return this.fetchItems(ip, port, GET_RULES_PATH, type, ruleType);
    }

    private boolean setRules(String app, String ip, int port, String type, List<? extends RuleEntity> entities) {
        if (entities == null) {
            return true;
        }
        try {
            AssertUtil.notEmpty((String)app, (String)"Bad app name");
            AssertUtil.notEmpty((String)ip, (String)"Bad machine IP");
            AssertUtil.isTrue((port > 0 ? 1 : 0) != 0, (String)"Bad machine port");
            String data = JSON.toJSONString(entities.stream().map(r -> r.toRule()).collect(Collectors.toList()));
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("type", type);
            params.put("data", data);
            String result = this.executeCommand(app, ip, port, SET_RULES_PATH, params, true).get();
            logger.info("setRules result: {}, type={}", (Object)result, (Object)type);
            return true;
        }
        catch (InterruptedException e) {
            logger.warn("setRules API failed: {}", (Object)type, (Object)e);
            return false;
        }
        catch (ExecutionException e) {
            logger.warn("setRules API failed: {}", (Object)type, (Object)e.getCause());
            return false;
        }
        catch (Exception e) {
            logger.error("setRules API failed, type={}", (Object)type, (Object)e);
            return false;
        }
    }

    private CompletableFuture<Void> setRulesAsync(String app, String ip, int port, String type, List<? extends RuleEntity> entities) {
        try {
            AssertUtil.notNull(entities, (String)"rules cannot be null");
            AssertUtil.notEmpty((String)app, (String)"Bad app name");
            AssertUtil.notEmpty((String)ip, (String)"Bad machine IP");
            AssertUtil.isTrue((port > 0 ? 1 : 0) != 0, (String)"Bad machine port");
            String data = JSON.toJSONString(entities.stream().map(r -> r.toRule()).collect(Collectors.toList()));
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("type", type);
            params.put("data", data);
            return this.executeCommand(app, ip, port, SET_RULES_PATH, params, true).thenCompose(r -> {
                if ("success".equalsIgnoreCase(r.trim())) {
                    return CompletableFuture.completedFuture(null);
                }
                return AsyncUtils.newFailedFuture(new CommandFailedException((String)r));
            });
        }
        catch (Exception e) {
            logger.error("setRulesAsync API failed, type={}", (Object)type, (Object)e);
            return AsyncUtils.newFailedFuture(e);
        }
    }

    public List<NodeVo> fetchResourceOfMachine(String ip, int port, String type) {
        return this.fetchItems(ip, port, RESOURCE_URL_PATH, type, NodeVo.class);
    }

    public List<NodeVo> fetchClusterNodeOfMachine(String ip, int port, boolean includeZero) {
        String type = "notZero";
        if (includeZero) {
            type = "zero";
        }
        return this.fetchItems(ip, port, CLUSTER_NODE_PATH, type, NodeVo.class);
    }

    public List<FlowRuleEntity> fetchFlowRuleOfMachine(String app, String ip, int port) {
        List<FlowRule> rules = this.fetchRules(ip, port, FLOW_RULE_TYPE, FlowRule.class);
        if (rules != null) {
            return rules.stream().map(rule -> FlowRuleEntity.fromFlowRule(app, ip, port, rule)).collect(Collectors.toList());
        }
        return null;
    }

    public List<DegradeRuleEntity> fetchDegradeRuleOfMachine(String app, String ip, int port) {
        List<DegradeRule> rules = this.fetchRules(ip, port, DEGRADE_RULE_TYPE, DegradeRule.class);
        if (rules != null) {
            return rules.stream().map(rule -> DegradeRuleEntity.fromDegradeRule(app, ip, port, rule)).collect(Collectors.toList());
        }
        return null;
    }

    public List<SystemRuleEntity> fetchSystemRuleOfMachine(String app, String ip, int port) {
        List<SystemRule> rules = this.fetchRules(ip, port, SYSTEM_RULE_TYPE, SystemRule.class);
        if (rules != null) {
            return rules.stream().map(rule -> SystemRuleEntity.fromSystemRule(app, ip, port, rule)).collect(Collectors.toList());
        }
        return null;
    }

    public CompletableFuture<List<ParamFlowRuleEntity>> fetchParamFlowRulesOfMachine(String app, String ip, int port) {
        try {
            AssertUtil.notEmpty((String)app, (String)"Bad app name");
            AssertUtil.notEmpty((String)ip, (String)"Bad machine IP");
            AssertUtil.isTrue((port > 0 ? 1 : 0) != 0, (String)"Bad machine port");
            return this.fetchItemsAsync(ip, port, GET_PARAM_RULE_PATH, null, ParamFlowRule.class).thenApply(rules -> rules.stream().map(e -> ParamFlowRuleEntity.fromAuthorityRule(app, ip, port, e)).collect(Collectors.toList()));
        }
        catch (Exception e) {
            logger.error("Error when fetching parameter flow rules", (Throwable)e);
            return AsyncUtils.newFailedFuture(e);
        }
    }

    public List<AuthorityRuleEntity> fetchAuthorityRulesOfMachine(String app, String ip, int port) {
        AssertUtil.notEmpty((String)app, (String)"Bad app name");
        AssertUtil.notEmpty((String)ip, (String)"Bad machine IP");
        AssertUtil.isTrue((port > 0 ? 1 : 0) != 0, (String)"Bad machine port");
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("type", AUTHORITY_TYPE);
        List<AuthorityRule> rules = this.fetchRules(ip, port, AUTHORITY_TYPE, AuthorityRule.class);
        return Optional.ofNullable(rules).map(r -> r.stream().map(e -> AuthorityRuleEntity.fromAuthorityRule(app, ip, port, e)).collect(Collectors.toList())).orElse(null);
    }

    public boolean setFlowRuleOfMachine(String app, String ip, int port, List<FlowRuleEntity> rules) {
        return this.setRules(app, ip, port, FLOW_RULE_TYPE, rules);
    }

    public CompletableFuture<Void> setFlowRuleOfMachineAsync(String app, String ip, int port, List<FlowRuleEntity> rules) {
        return this.setRulesAsync(app, ip, port, FLOW_RULE_TYPE, rules);
    }

    public boolean setDegradeRuleOfMachine(String app, String ip, int port, List<DegradeRuleEntity> rules) {
        return this.setRules(app, ip, port, DEGRADE_RULE_TYPE, rules);
    }

    public boolean setSystemRuleOfMachine(String app, String ip, int port, List<SystemRuleEntity> rules) {
        return this.setRules(app, ip, port, SYSTEM_RULE_TYPE, rules);
    }

    public boolean setAuthorityRuleOfMachine(String app, String ip, int port, List<AuthorityRuleEntity> rules) {
        return this.setRules(app, ip, port, AUTHORITY_TYPE, rules);
    }

    public CompletableFuture<Void> setParamFlowRuleOfMachine(String app, String ip, int port, List<ParamFlowRuleEntity> rules) {
        if (rules == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (StringUtil.isBlank((String)ip) || port <= 0) {
            return AsyncUtils.newFailedFuture(new IllegalArgumentException("Invalid parameter"));
        }
        try {
            String data = JSON.toJSONString(rules.stream().map(AbstractRuleEntity::getRule).collect(Collectors.toList()));
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("data", data);
            return this.executeCommand(app, ip, port, SET_PARAM_RULE_PATH, params, true).thenCompose(e -> {
                if ("success".equals(e)) {
                    return CompletableFuture.completedFuture(null);
                }
                logger.warn("Push parameter flow rules to client failed: " + e);
                return AsyncUtils.newFailedFuture(new RuntimeException((String)e));
            });
        }
        catch (Exception ex) {
            logger.warn("Error when setting parameter flow rule", (Throwable)ex);
            return AsyncUtils.newFailedFuture(ex);
        }
    }

    public CompletableFuture<ClusterStateSimpleEntity> fetchClusterMode(String ip, int port) {
        if (StringUtil.isBlank((String)ip) || port <= 0) {
            return AsyncUtils.newFailedFuture(new IllegalArgumentException("Invalid parameter"));
        }
        try {
            return this.executeCommand(ip, port, FETCH_CLUSTER_MODE_PATH, false).thenApply(r -> (ClusterStateSimpleEntity)JSON.parseObject((String)r, ClusterStateSimpleEntity.class));
        }
        catch (Exception ex) {
            logger.warn("Error when fetching cluster mode", (Throwable)ex);
            return AsyncUtils.newFailedFuture(ex);
        }
    }

    public CompletableFuture<Void> modifyClusterMode(String ip, int port, int mode) {
        if (StringUtil.isBlank((String)ip) || port <= 0) {
            return AsyncUtils.newFailedFuture(new IllegalArgumentException("Invalid parameter"));
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("mode", String.valueOf(mode));
            return this.executeCommand(ip, port, MODIFY_CLUSTER_MODE_PATH, params, false).thenCompose(e -> {
                if ("success".equals(e)) {
                    return CompletableFuture.completedFuture(null);
                }
                logger.warn("Error when modifying cluster mode: " + e);
                return AsyncUtils.newFailedFuture(new RuntimeException((String)e));
            });
        }
        catch (Exception ex) {
            logger.warn("Error when modifying cluster mode", (Throwable)ex);
            return AsyncUtils.newFailedFuture(ex);
        }
    }

    public CompletableFuture<ClusterClientInfoVO> fetchClusterClientInfoAndConfig(String ip, int port) {
        if (StringUtil.isBlank((String)ip) || port <= 0) {
            return AsyncUtils.newFailedFuture(new IllegalArgumentException("Invalid parameter"));
        }
        try {
            return this.executeCommand(ip, port, FETCH_CLUSTER_CLIENT_CONFIG_PATH, false).thenApply(r -> (ClusterClientInfoVO)JSON.parseObject((String)r, ClusterClientInfoVO.class));
        }
        catch (Exception ex) {
            logger.warn("Error when fetching cluster client config", (Throwable)ex);
            return AsyncUtils.newFailedFuture(ex);
        }
    }

    public CompletableFuture<Void> modifyClusterClientConfig(String app, String ip, int port, ClusterClientConfig config) {
        if (StringUtil.isBlank((String)ip) || port <= 0) {
            return AsyncUtils.newFailedFuture(new IllegalArgumentException("Invalid parameter"));
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("data", JSON.toJSONString((Object)config));
            return this.executeCommand(app, ip, port, MODIFY_CLUSTER_CLIENT_CONFIG_PATH, params, true).thenCompose(e -> {
                if ("success".equals(e)) {
                    return CompletableFuture.completedFuture(null);
                }
                logger.warn("Error when modifying cluster client config: " + e);
                return AsyncUtils.newFailedFuture(new RuntimeException((String)e));
            });
        }
        catch (Exception ex) {
            logger.warn("Error when modifying cluster client config", (Throwable)ex);
            return AsyncUtils.newFailedFuture(ex);
        }
    }

    public CompletableFuture<Void> modifyClusterServerFlowConfig(String app, String ip, int port, ServerFlowConfig config) {
        if (StringUtil.isBlank((String)ip) || port <= 0) {
            return AsyncUtils.newFailedFuture(new IllegalArgumentException("Invalid parameter"));
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("data", JSON.toJSONString((Object)config));
            return this.executeCommand(app, ip, port, MODIFY_CLUSTER_SERVER_FLOW_CONFIG_PATH, params, true).thenCompose(e -> {
                if ("success".equals(e)) {
                    return CompletableFuture.completedFuture(null);
                }
                logger.warn("Error when modifying cluster server flow config: " + e);
                return AsyncUtils.newFailedFuture(new RuntimeException((String)e));
            });
        }
        catch (Exception ex) {
            logger.warn("Error when modifying cluster server flow config", (Throwable)ex);
            return AsyncUtils.newFailedFuture(ex);
        }
    }

    public CompletableFuture<Void> modifyClusterServerTransportConfig(String app, String ip, int port, ServerTransportConfig config) {
        if (StringUtil.isBlank((String)ip) || port <= 0) {
            return AsyncUtils.newFailedFuture(new IllegalArgumentException("Invalid parameter"));
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("port", config.getPort().toString());
            params.put("idleSeconds", config.getIdleSeconds().toString());
            return this.executeCommand(app, ip, port, MODIFY_CLUSTER_SERVER_TRANSPORT_CONFIG_PATH, params, false).thenCompose(e -> {
                if ("success".equals(e)) {
                    return CompletableFuture.completedFuture(null);
                }
                logger.warn("Error when modifying cluster server transport config: " + e);
                return AsyncUtils.newFailedFuture(new RuntimeException((String)e));
            });
        }
        catch (Exception ex) {
            logger.warn("Error when modifying cluster server transport config", (Throwable)ex);
            return AsyncUtils.newFailedFuture(ex);
        }
    }

    public CompletableFuture<Void> modifyClusterServerNamespaceSet(String app, String ip, int port, Set<String> set) {
        if (StringUtil.isBlank((String)ip) || port <= 0) {
            return AsyncUtils.newFailedFuture(new IllegalArgumentException("Invalid parameter"));
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("data", JSON.toJSONString(set));
            return this.executeCommand(app, ip, port, MODIFY_CLUSTER_SERVER_NAMESPACE_SET_PATH, params, true).thenCompose(e -> {
                if ("success".equals(e)) {
                    return CompletableFuture.completedFuture(null);
                }
                logger.warn("Error when modifying cluster server NamespaceSet", e);
                return AsyncUtils.newFailedFuture(new RuntimeException((String)e));
            });
        }
        catch (Exception ex) {
            logger.warn("Error when modifying cluster server NamespaceSet", (Throwable)ex);
            return AsyncUtils.newFailedFuture(ex);
        }
    }

    public CompletableFuture<ClusterServerStateVO> fetchClusterServerBasicInfo(String ip, int port) {
        if (StringUtil.isBlank((String)ip) || port <= 0) {
            return AsyncUtils.newFailedFuture(new IllegalArgumentException("Invalid parameter"));
        }
        try {
            return this.executeCommand(ip, port, FETCH_CLUSTER_SERVER_BASIC_INFO_PATH, false).thenApply(r -> (ClusterServerStateVO)JSON.parseObject((String)r, ClusterServerStateVO.class));
        }
        catch (Exception ex) {
            logger.warn("Error when fetching cluster sever all config and basic info", (Throwable)ex);
            return AsyncUtils.newFailedFuture(ex);
        }
    }

    public CompletableFuture<List<ApiDefinitionEntity>> fetchApis(String app, String ip, int port) {
        if (StringUtil.isBlank((String)ip) || port <= 0) {
            return AsyncUtils.newFailedFuture(new IllegalArgumentException("Invalid parameter"));
        }
        try {
            return this.executeCommand(ip, port, FETCH_GATEWAY_API_PATH, false).thenApply(r -> {
                List entities = JSON.parseArray((String)r, ApiDefinitionEntity.class);
                if (entities != null) {
                    for (ApiDefinitionEntity entity : entities) {
                        entity.setApp(app);
                        entity.setIp(ip);
                        entity.setPort(port);
                    }
                }
                return entities;
            });
        }
        catch (Exception ex) {
            logger.warn("Error when fetching gateway apis", (Throwable)ex);
            return AsyncUtils.newFailedFuture(ex);
        }
    }

    public boolean modifyApis(String app, String ip, int port, List<ApiDefinitionEntity> apis) {
        if (apis == null) {
            return true;
        }
        try {
            AssertUtil.notEmpty((String)app, (String)"Bad app name");
            AssertUtil.notEmpty((String)ip, (String)"Bad machine IP");
            AssertUtil.isTrue((port > 0 ? 1 : 0) != 0, (String)"Bad machine port");
            String data = JSON.toJSONString(apis.stream().map(r -> r.toApiDefinition()).collect(Collectors.toList()));
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("data", data);
            String result = this.executeCommand(app, ip, port, MODIFY_GATEWAY_API_PATH, params, true).get();
            logger.info("Modify gateway apis: {}", (Object)result);
            return true;
        }
        catch (Exception e) {
            logger.warn("Error when modifying gateway apis", (Throwable)e);
            return false;
        }
    }

    public CompletableFuture<List<GatewayFlowRuleEntity>> fetchGatewayFlowRules(String app, String ip, int port) {
        if (StringUtil.isBlank((String)ip) || port <= 0) {
            return AsyncUtils.newFailedFuture(new IllegalArgumentException("Invalid parameter"));
        }
        try {
            return this.executeCommand(ip, port, FETCH_GATEWAY_FLOW_RULE_PATH, false).thenApply(r -> {
                List gatewayFlowRules = JSON.parseArray((String)r, GatewayFlowRule.class);
                List entities = gatewayFlowRules.stream().map(rule -> GatewayFlowRuleEntity.fromGatewayFlowRule(app, ip, port, rule)).collect(Collectors.toList());
                return entities;
            });
        }
        catch (Exception ex) {
            logger.warn("Error when fetching gateway flow rules", (Throwable)ex);
            return AsyncUtils.newFailedFuture(ex);
        }
    }

    public boolean modifyGatewayFlowRules(String app, String ip, int port, List<GatewayFlowRuleEntity> rules) {
        if (rules == null) {
            return true;
        }
        try {
            AssertUtil.notEmpty((String)app, (String)"Bad app name");
            AssertUtil.notEmpty((String)ip, (String)"Bad machine IP");
            AssertUtil.isTrue((port > 0 ? 1 : 0) != 0, (String)"Bad machine port");
            String data = JSON.toJSONString(rules.stream().map(r -> r.toGatewayFlowRule()).collect(Collectors.toList()));
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("data", data);
            String result = this.executeCommand(app, ip, port, MODIFY_GATEWAY_FLOW_RULE_PATH, params, true).get();
            logger.info("Modify gateway flow rules: {}", (Object)result);
            return true;
        }
        catch (Exception e) {
            logger.warn("Error when modifying gateway apis", (Throwable)e);
            return false;
        }
    }
}

