/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.config;

import com.alibaba.csp.sentinel.adapter.servlet.CommonFilter;
import com.alibaba.csp.sentinel.adapter.servlet.callback.WebCallbackManager;
import com.alibaba.csp.sentinel.dashboard.auth.AuthorizationInterceptor;
import com.alibaba.csp.sentinel.dashboard.auth.LoginAuthenticationFilter;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebConfig
implements WebMvcConfigurer {
    private final Logger logger = LoggerFactory.getLogger(WebConfig.class);
    @Autowired
    private LoginAuthenticationFilter loginAuthenticationFilter;
    @Autowired
    private AuthorizationInterceptor authorizationInterceptor;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.authorizationInterceptor).addPathPatterns(new String[]{"/**"});
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"classpath:/resources/"});
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/").setViewName("forward:/index.htm");
    }

    @Bean
    public FilterRegistrationBean sentinelFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new CommonFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("sentinelFilter");
        registration.setOrder(1);
        registration.addInitParameter("WEB_CONTEXT_UNIFY", "true");
        this.logger.info("Sentinel servlet CommonFilter registered");
        return registration;
    }

    @PostConstruct
    public void doInit() {
        HashSet<String> suffixSet = new HashSet<String>(Arrays.asList(".js", ".css", ".html", ".ico", ".txt", ".woff", ".woff2"));
        WebCallbackManager.setUrlCleaner(url -> {
            if (StringUtil.isEmpty((String)url)) {
                return url;
            }
            if (suffixSet.stream().anyMatch(url::endsWith)) {
                return null;
            }
            return url;
        });
    }

    @Bean
    public FilterRegistrationBean authenticationFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)this.loginAuthenticationFilter);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("authenticationFilter");
        registration.setOrder(0);
        return registration;
    }
}

