package com.xforceplus.delivery.cloud.tax.pur.verify.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xforceplus.delivery.cloud.common.api.PageResult;
import com.xforceplus.delivery.cloud.common.api.ViewResult;
import com.xforceplus.delivery.cloud.common.util.BeanUtils;
import com.xforceplus.delivery.cloud.common.util.DateUtils;
import com.xforceplus.delivery.cloud.common.util.StringUtils;
import com.xforceplus.delivery.cloud.gen.purchaser.entity.PurchaserVerifyRecordEntity;
import com.xforceplus.delivery.cloud.gen.purchaser.service.IPurchaserVerifyRecordService;
import com.xforceplus.delivery.cloud.mybatis.ExampleWrapper;
import com.xforceplus.delivery.cloud.mybatis.PageQueryStringHandler;
import com.xforceplus.delivery.cloud.mybatis.ViewPage;
import com.xforceplus.delivery.cloud.tax.pur.verify.domain.VerifyMain;
import com.xforceplus.delivery.cloud.tax.pur.verify.domain.VerifyParamVo;
import com.xforceplus.delivery.cloud.tax.pur.verify.domain.VerifyRequestVo;
import com.xforceplus.delivery.cloud.tax.pur.verify.service.IPurchaserInvoiceVerifyService;
import com.xforceplus.delivery.cloud.webmvc.support.QueryString;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.Map;
import java.util.Objects;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author Hanyongjie
 * @since 2020-06-19
 */
@Slf4j
@RestController
@RequestMapping("/purchaser/verify")
public class PurchaserVerifyRecordController {

    @Autowired
    private IPurchaserVerifyRecordService iPurchaserVerifyRecordService;

    @Autowired
    private IPurchaserInvoiceVerifyService iPurchaserInvoiceVerifyService;

    @PostMapping("/record/list")
    @ApiOperation("验真记录列表")
    @PreAuthorize("hasAuthority('purchaser:verify:view')")
    public PageResult<PurchaserVerifyRecordEntity> list(@RequestBody Map<String, String> params, @QueryString(handler = {PageQueryStringHandler.class}) Page<PurchaserVerifyRecordEntity> page) {
        return ViewPage.of(this.iPurchaserVerifyRecordService.page(page, new ExampleWrapper<>(PurchaserVerifyRecordEntity.class, params)));
    }

    @PostMapping("/upload")
    @ApiOperation("税件发票验真接口")
    @PreAuthorize("hasAuthority('purchaser:verify:upload')")
    public ViewResult<Object> verify(@RequestBody VerifyParamVo verifyParam) {
        if (Objects.isNull(verifyParam)) {
            log.warn("验真参数不能为空");
            return ViewResult.failed("验真参数不能为空");
        }
        return this.iPurchaserInvoiceVerifyService.verify(verifyParam);
    }

    @PostMapping("/retry")
    @ApiOperation("发票验真重发接口")
    @PreAuthorize("hasAuthority('purchaser:verify:retry')")
    public ViewResult<Object> again(@RequestBody VerifyParamVo verifyParam) {
        if (Objects.isNull(verifyParam)) {
            log.warn("验真参数不能为空");
            return ViewResult.failed("验真参数不能为空");
        }
        PurchaserVerifyRecordEntity record = iPurchaserVerifyRecordService.getById(verifyParam.getId());
        if (record == null) {
            log.warn("验真记录不存在");
            return ViewResult.failed("验真记录不存在");
        }
        BeanUtils.copyObject(record, verifyParam);
        verifyParam.setPaperDrewDate(DateUtils.format(record.getPaperDrewDate(), "yyyyMMdd"));
        return this.iPurchaserInvoiceVerifyService.verify(verifyParam);
    }

    @PostMapping("/retry-v4")
    @ApiOperation("4.0发票验真重发接口")
    @PreAuthorize("hasAuthority('purchaser:verify:retry-v4')")
    public ViewResult<Object> again4(@RequestBody VerifyRequestVo verifyRequest) {
        if (Objects.isNull(verifyRequest)) {
            log.warn("验真参数不能为空");
            return ViewResult.failed("验真参数不能为空");
        }
        return this.iPurchaserInvoiceVerifyService.verify4(verifyRequest);
    }

    @PostMapping("/upload-v4")
    @ApiOperation("4.0发票验真接口")
    @PreAuthorize("hasAuthority('purchaser:verify:upload-v4')")
    public ViewResult<Object> verify4(@RequestBody VerifyRequestVo verifyRequest) {
        if (Objects.isNull(verifyRequest)) {
            log.warn("验真参数不能为空");
            return ViewResult.failed("验真参数不能为空");
        }
        return this.iPurchaserInvoiceVerifyService.verify4(verifyRequest);
    }

    @GetMapping("/query")
    @ApiOperation("查询发票验真结果接口")
    @PreAuthorize("hasAuthority('purchaser:verify:query')")
    public ViewResult<VerifyMain> queryResult(@RequestParam("taskId") String taskId) {
        if (StringUtils.isBlank(taskId)) {
            log.warn("查询发票验真结果参数不能为空");
            return ViewResult.failed("查询发票验真结果参数不能为空");
        }
        return this.iPurchaserInvoiceVerifyService.queryResult(taskId);
    }

}

