package com.xforceplus.delivery.cloud.tax.pur.verify.service;

import com.xforceplus.core.remote.domain.VerifyRequest;
import com.xforceplus.delivery.cloud.common.api.ViewResult;
import com.xforceplus.delivery.cloud.tax.pur.verify.domain.VerifyMain;
import com.xforceplus.delivery.cloud.tax.pur.verify.domain.VerifyParamVo;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author Hanyongjie
 * @since 2020-06-19
 */
public interface IPurchaserInvoiceVerifyService {

    /**
     * 发票验真
     * 流程：对接税件的验真接口->税件把结果回给4.0平台
     *
     * @param verifyParam
     * @return ViewResult<Object>
     * @throws
     * @Methods: verify
     */
    ViewResult<Object> verify(VerifyParamVo verifyParam);

    /**
     * 发票验真
     * 流程：走4.0平台的验真接口->4.0平台再去调用税件接口->最后拿回验真结果
     *
     * @param verifyRequest
     * @return ViewResult<Object>
     * @throws
     * @Methods: verify
     */
    ViewResult<Object> verify4(VerifyRequest verifyRequest);

    /**
     * 查询验真结果
     *
     * @param taskId
     * @return ViewResult<Object>
     * @throws
     * @Methods: queryResult
     */
    ViewResult<VerifyMain> queryResult(String taskId);

    /**
     * 保存和更新发票主信息和验真记录
     *
     * @param taskId
     * @param verifyMain void
     * @throws
     * @Methods: saveOrUpdateInvoiceInfo
     */
    void saveOrUpdateInvoiceInfo(String taskId, VerifyMain verifyMain);

}
