/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.eccp.x.domain.common;

import com.google.common.base.Splitter;
import com.xforceplus.eccp.x.domain.common.enums.SubDomainEnum;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class SubDomainPath
implements Serializable {
    private Domain subDomain;
    private Domain line;
    private SubDomainEnum domainEnum;

    public static SubDomainPath parsePath(String path) {
        List domains = Splitter.on((String)".").splitToList((CharSequence)path);
        if (CollectionUtils.isEmpty((Collection)domains)) {
            return null;
        }
        SubDomainPath domainPath = new SubDomainPath();
        for (int i = 0; i < domains.size(); ++i) {
            String subDomains = (String)domains.get(i);
            List items = Splitter.on((String)":").splitToList((CharSequence)subDomains);
            Domain domain = new Domain();
            for (int j = 0; j < items.size(); ++j) {
                String item = (String)items.get(j);
                if (j == 0) {
                    domain.setName(item);
                    continue;
                }
                if (j != 1 || !NumberUtils.isDigits((String)item)) continue;
                domain.setSize(Integer.valueOf(item));
            }
            if (i == 0) {
                domainPath.subDomain = domain;
                continue;
            }
            if (i != 1) continue;
            domainPath.line = domain;
        }
        domainPath.domainEnum = SubDomainEnum.build(domainPath.subDomain.name);
        return domainPath;
    }

    public static SubDomainPath parsePath(String path, SubDomainEnum defaultDomainEnum) {
        SubDomainPath subDomainPath = SubDomainPath.parsePath(path);
        if (Objects.isNull(subDomainPath)) {
            subDomainPath = SubDomainPath.build(defaultDomainEnum);
        }
        return subDomainPath;
    }

    public static SubDomainPath build(SubDomainEnum domainEnum) {
        SubDomainPath domainPath = new SubDomainPath();
        Domain subDomain = new Domain();
        subDomain.setName(domainEnum.name());
        domainPath.subDomain = subDomain;
        domainPath.domainEnum = domainEnum;
        return domainPath;
    }

    public SubDomainPath withLines() {
        return this.withLines(null);
    }

    public SubDomainPath withSize(Integer size) {
        if (Objects.isNull(this.subDomain)) {
            return this;
        }
        this.subDomain.setSize(size);
        return this;
    }

    public SubDomainPath withLines(Integer size) {
        if (Objects.isNull(this.line)) {
            this.line = new Domain();
        }
        if (Objects.nonNull(size)) {
            this.line.setSize(size);
        }
        return this;
    }

    public Domain getSubDomain() {
        return this.subDomain;
    }

    public Domain getLine() {
        return this.line;
    }

    public Boolean includeLines() {
        return Objects.nonNull(this.line);
    }

    public SubDomainEnum getDomainEnum() {
        return this.domainEnum;
    }

    public static void main(String[] args) {
        SubDomainPath path = SubDomainPath.parsePath("order");
        System.out.println(path);
    }

    public static class Domain
    implements Serializable {
        private String name;
        private Integer size = 10;

        public String getName() {
            return this.name;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Domain)) {
                return false;
            }
            Domain other = (Domain)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Integer this$size = this.getSize();
            Integer other$size = other.getSize();
            return !(this$size == null ? other$size != null : !((Object)this$size).equals(other$size));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Domain;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Integer $size = this.getSize();
            result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
            return result;
        }

        public String toString() {
            return "SubDomainPath.Domain(name=" + this.getName() + ", size=" + this.getSize() + ")";
        }
    }
}

