/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.eccp.x.domain.common;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.eccp.common.stub.CommonErrorEnum;
import com.xforceplus.eccp.x.domain.common.auth.CurrentUser;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Component
public class TokenHelper
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(TokenHelper.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${base.token.url:https://paas.xforceplus.com}")
    private String paasUrl;
    @Value(value="${base.token.username}")
    private String username;
    @Value(value="${base.token.password}")
    private String password;
    @Value(value="${base.token.apiPath:/api/normal/login}")
    private String apiPath;
    @Value(value="${coop.security.msCenter.tokenCacheTime:2}")
    private Integer tokenCacheTime;
    private static String cacheToken;
    private static Long cacheTime;

    public String stealAccessToken() {
        String cacheToken = this.getCacheToken();
        if (null != cacheToken) {
            log.info("##### \u83b7\u53d6\u672c\u5730\u7f13\u5b58\u8ba4\u8bc1token: {}", (Object)cacheToken);
            return cacheToken;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("username", (Object)this.username);
        jsonObject.put("password", (Object)this.password);
        jsonObject.put("captcha", (Object)"");
        log.info("##### get Token normalLogin\u767b\u5f55\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)jsonObject.toString());
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        String url = this.paasUrl + this.apiPath;
        log.info("#### get Token  normalLogin\u767b\u5f55\u5730\u5740\uff1a{}", (Object)url);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity((Object)jsonObject, (MultiValueMap)headers), JSONObject.class, new Object[0]);
        log.info("##### get Token  normalLogin\u767b\u5f55\u63a5\u53e3\u54cd\u5e94\uff1a{}", (Object)responseEntity);
        String token = this.getResponse((ResponseEntity<JSONObject>)responseEntity);
        this.setCacheToken(token);
        return token;
    }

    private String getResponse(ResponseEntity<JSONObject> responseEntity) {
        try {
            JSONObject resp = (JSONObject)responseEntity.getBody();
            String code = resp.getString("code");
            if (CommonErrorEnum.Success.getCode().equals(code)) {
                JSONObject data = resp.getJSONObject("data");
                String token = data.getString("xforce-saas-token");
                if (StringUtils.isEmpty((Object)token)) {
                    log.error("token \u4e3a\u7a7a\uff0c\u767b\u5f55\u5931\u8d25");
                }
                return token;
            }
        }
        catch (Exception e) {
            log.error("##### \u83b7\u53d6token \u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        return null;
    }

    private synchronized void setCacheToken(String token) {
        cacheTime = System.currentTimeMillis() + (long)(this.tokenCacheTime * 60 * 60 * 1000);
        cacheToken = token;
        log.info("##### \u672c\u5730\u7f13\u5b58\u65f6\u95f4\uff1a{} \u5c0f\u65f6 \u5fae\u670d\u52a1\u8ba4\u8bc1token\uff1a{}", (Object)this.tokenCacheTime, (Object)token);
    }

    private synchronized String getCacheToken() {
        if (null != cacheToken) {
            if (cacheTime > System.currentTimeMillis()) {
                return cacheToken;
            }
            cacheToken = null;
        }
        return null;
    }

    public static void deleteCacheToken() {
        cacheToken = null;
        cacheTime = 0L;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        TokenHelper bean;
        CurrentUser.tokenHelper = bean = (TokenHelper)applicationContext.getBean(TokenHelper.class);
        log.info("##### CurrentUserExt.tokenHelper \u8bbe\u7f6e\u6210\u529f:{}", (Object)bean);
    }
}

