/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.eccp.x.domain.common.auth;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.eccp.x.domain.common.TokenHelper;
import com.xforceplus.tenant.security.core.jwt.JwtUtils;
import com.xforceplus.tenant.security.core.utils.CompressionUtils;
import com.xforceplus.tenantsecurity.domain.AuthorizedUser;
import com.xforceplus.tenantsecurity.domain.IAuthorizedUser;
import com.xforceplus.tenantsecurity.domain.ICompany;
import com.xforceplus.tenantsecurity.domain.IOrg;
import com.xforceplus.tenantsecurity.domain.IRole;
import com.xforceplus.tenantsecurity.domain.UserInfoHolder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentUser {
    static Logger logger = LoggerFactory.getLogger(CurrentUser.class);
    public static TokenHelper tokenHelper;

    public static IAuthorizedUser getAuthorizedUser() {
        return UserInfoHolder.get();
    }

    public static String getToken() {
        return CurrentUser.getAuthorizedUser().token();
    }

    public static String getCurrentEmail() {
        String email = null;
        try {
            email = CurrentUser.getAuthorizedUser().getEmail();
        }
        catch (Exception e) {
            email = "";
        }
        logger.info("\u5f53\u524d\u7528\u6237email={}", (Object)email);
        return email;
    }

    public static String getCurrentMobile() {
        String mobile = null;
        try {
            mobile = CurrentUser.getAuthorizedUser().getMobile();
        }
        catch (Exception e) {
            mobile = "";
        }
        logger.info("\u5f53\u524d\u7528\u6237mobile={}", (Object)mobile);
        return mobile;
    }

    public static Long getCurrentUserId() {
        Long userId = null;
        try {
            userId = CurrentUser.getAuthorizedUser().getId();
        }
        catch (Exception e) {
            userId = 0L;
        }
        logger.info("\u5f53\u524d\u7528\u6237id={}", (Object)userId);
        return userId;
    }

    public static String getCurrentUserName() {
        String userName = null;
        try {
            userName = CurrentUser.getAuthorizedUser().getUsername();
        }
        catch (Exception e) {
            userName = "system";
        }
        logger.info("\u5f53\u524d\u7528\u6237userName={}", (Object)userName);
        return userName;
    }

    public static String getTenantName() {
        return CurrentUser.getAuthorizedUser().getTenantName();
    }

    public static Long getTenantId() {
        Long tenantId = CurrentUser.getAuthorizedUser().getTenantId();
        logger.info("\u5f53\u524d\u79df\u6237id={}", (Object)tenantId);
        return tenantId;
    }

    public static String getTenantCode() {
        String tenantCode = CurrentUser.getAuthorizedUser().getTenantCode();
        logger.info("\u5f53\u524d\u79df\u6237code={}", (Object)tenantCode);
        return tenantCode;
    }

    public static Long getAccountId() {
        Long accountId = CurrentUser.getAuthorizedUser().getAccountId();
        logger.info("\u5f53\u524d\u8d26\u6237id={}", (Object)accountId);
        return accountId;
    }

    public static List<IOrg> getOrgs() {
        return CurrentUser.getAuthorizedUser().getOrgs();
    }

    public static Set<IRole> getRoles() {
        return CurrentUser.getAuthorizedUser().getRoles();
    }

    public static Set<ICompany> getCompanies() {
        return CurrentUser.getAuthorizedUser().getCompanies();
    }

    public static List<Long> getAppIds() {
        List appIds = CurrentUser.getAuthorizedUser().getAppIds();
        logger.info("\u5f53\u524d\u7528\u6237appIds={}", (Object)appIds);
        return appIds;
    }

    public static List<Long> getAppIds(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return CurrentUser.getAppIds();
        }
        return Arrays.asList(Long.parseLong(appId));
    }

    public static void setCurrentTenant(Long tenantId) {
        AuthorizedUser user = (AuthorizedUser)CurrentUser.getAuthorizedUser();
        if (Objects.isNull(user)) {
            user = new AuthorizedUser();
            user.setId(0L);
            user.setUsername("system");
            user.setToken("system-token");
            try {
                String accessToken = tokenHelper.stealAccessToken();
                user.setToken(accessToken);
            }
            catch (Exception e) {
                logger.error("##### tokenHelper \u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
            UserInfoHolder.put((IAuthorizedUser)user);
        }
        user.setTenantId(tenantId.longValue());
    }

    public static void loginToken(String secret, String token) {
        Map claims = JwtUtils.verifyAndDecodeToken((String)secret, (String)token);
        String encodedUserInfo = (String)claims.get("userinfo");
        String userinfo = CompressionUtils.decode((String)encodedUserInfo);
        JSONObject userInfo = JSON.parseObject((String)userinfo);
        if (userInfo != null) {
            AuthorizedUser authorizedUser = new AuthorizedUser();
            authorizedUser.setTenantName(userInfo.get("tenantName") + "");
            authorizedUser.setUsername(userInfo.get("username") + "");
            authorizedUser.setAccountId(Long.parseLong(userInfo.get("accountId") + ""));
            authorizedUser.setEmail(userInfo.get("email") + "");
            authorizedUser.setTenantCode(userInfo.get("tenantCode") + "");
            authorizedUser.setTenantId(Long.parseLong(userInfo.get("tenantId") + ""));
            authorizedUser.setMobile(userInfo.get("mobile") + "");
            authorizedUser.setId(Long.parseLong(userInfo.get("id") + ""));
            authorizedUser.setToken(token);
            UserInfoHolder.put((IAuthorizedUser)authorizedUser);
        }
    }
}

