/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.eccp.x.domain.common.intercepter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.xforceplus.eccp.x.domain.common.auth.CurrentUser;
import com.xforceplus.eccp.x.domain.common.utils.ReqParamsHolder;
import com.xforceplus.tenantsecurity.annotation.WithoutAuth;
import com.xforceplus.tenantsecurity.domain.AuthorizedUser;
import com.xforceplus.tenantsecurity.domain.IAuthorizedUser;
import com.xforceplus.tenantsecurity.domain.UserInfoHolder;
import com.xforceplus.tenantsecurity.jwt.JwtUtils;
import com.xforceplus.tenantsecurity.utils.CompressionUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import org.springframework.web.util.WebUtils;

public class NewTokenParserInterceptor
implements HandlerInterceptor {
    private Logger logger = LoggerFactory.getLogger(NewTokenParserInterceptor.class);
    @Value(value="${tenant.security.jwt.secret:my_sessionjw_tsecret_xdfdffdsdfdfs_fat}")
    private String secret;
    @Value(value="${tenant.security.authority.default.login-url:http://paas-t.xforceplus.com/login/}")
    private String loginUrl;

    private boolean isStaticPage(String url) {
        List<String> suffixList = Arrays.asList(".html", ".css", ".js", ".css", ".png", ".ttf");
        List<String> passList = Arrays.asList("swagger-resources/configuration/ui", "swagger-resources", "v2/api-docs", "swagger-resources/configuration/security", "health", "xplat/health", "error");
        if (StringUtils.isBlank((CharSequence)url)) {
            return false;
        }
        String path = url.trim();
        if (StringUtils.startsWith((CharSequence)path, (CharSequence)"/")) {
            path = StringUtils.substring((String)path, (int)1);
        }
        for (String pass : passList) {
            if (path.endsWith(pass)) {
                return true;
            }
            for (String suffix : suffixList) {
                if (!path.endsWith(pass + suffix)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        if (handler instanceof ResourceHttpRequestHandler) {
            return true;
        }
        boolean isStaticPage = this.isStaticPage(request.getRequestURI());
        if (isStaticPage) {
            this.logger.warn("TokenParser: isStaticPage");
            return true;
        }
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod method = (HandlerMethod)handler;
        boolean isWithoutAuth = method.hasMethodAnnotation(WithoutAuth.class);
        if (isWithoutAuth) {
            return true;
        }
        String token = request.getHeader("x-access-token");
        if (StringUtils.isEmpty((CharSequence)token)) {
            token = request.getHeader("X-Access-Token");
        }
        if (StringUtils.isEmpty((CharSequence)token)) {
            this.logger.warn("TokenParser: Header\u4e2d\u65e0x-access-token\u6216X-Access-Token");
            Cookie tokenCookie = WebUtils.getCookie((HttpServletRequest)request, (String)"xforce-saas-token");
            if (tokenCookie != null) {
                token = tokenCookie.getValue();
            }
            if (StringUtils.isEmpty((CharSequence)token)) {
                this.logger.warn("TokenParser: Cookie\u4e2d\u65e0xforce-saas-token");
                token = WebUtils.findParameterValue((ServletRequest)request, (String)"x-access-token");
                this.logger.info("WebUtils.findParameterValue====" + token);
            }
        }
        if (StringUtils.isEmpty((CharSequence)token)) {
            token = request.getHeader("x-app-token");
        }
        if (StringUtils.isEmpty((CharSequence)token)) {
            token = request.getHeader("xforce-saas-token");
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u6ca1\u6709\u767b\u5f55";
            this.logger.warn("TokenParser: token is Blank, " + message);
            this.responseUnauthorized(message, request, response);
            return false;
        }
        Map claims = null;
        if (StringUtils.isNotBlank((CharSequence)token)) {
            if ("system-token".equalsIgnoreCase(token)) {
                CurrentUser.setCurrentTenant(0L);
                return true;
            }
            try {
                claims = JwtUtils.verifyAndDecodeToken((String)this.secret, (String)token);
            }
            catch (TokenExpiredException e) {
                this.logger.error("token\u8fc7\u671f\u5f02\u5e38TokenExpiredException,token=={}", (Object)token);
                String message = "token\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55";
                this.responseUnauthorized(message, request, response);
                return false;
            }
            catch (Exception e) {
                String message = "token\u89e3\u6790\u5931\u8d25\u3002";
                this.logger.error(message + ",secret = " + this.secret + ", token=" + token, (Throwable)e);
                this.responseUnauthorized(message, request, response);
                return false;
            }
        }
        if (claims == null) {
            String message = "Token\u89e3\u6790\u8fd4\u56de\u4e3a\u7a7a";
            this.logger.warn("TokenParser: claims == null, " + message);
            this.responseUnauthorized(message, request, response);
            return false;
        }
        String systemType = (String)claims.get("type");
        if (!"1".equals(systemType)) {
            String message = "token\u975e\u6cd5\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55";
            this.logger.warn("TokenParser: claims == null, " + message);
            this.responseUnauthorized(message, request, response);
            return false;
        }
        String encodedUserInfo = (String)claims.get("userinfo");
        if (StringUtils.isBlank((CharSequence)encodedUserInfo)) {
            String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u65e0\u6548\u4ee4\u724c";
            this.logger.warn("TokenParser: userinfo is Blank, " + message);
            this.responseUnauthorized(message, request, response);
            return false;
        }
        String userinfo = CompressionUtils.decode((String)encodedUserInfo);
        if (StringUtils.isBlank((CharSequence)userinfo)) {
            String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u65e0\u6548\u4ee4\u724c";
            this.logger.warn("TokenParser: userinfo == null, " + message);
            this.responseUnauthorized(message, request, response);
            return false;
        }
        try {
            return this.setUserInfoHolder(userinfo, token, null, method);
        }
        catch (Exception e) {
            String message = "\u89e3\u6790\u7528\u6237\u4e0a\u4e0b\u6587\u53d1\u751f\u5f02\u5e38 ";
            this.logger.error("TokenParser: {}\uff0c{}", (Object)message, (Object)e);
            this.responseUnauthorized(message, request, response);
            return false;
        }
    }

    private boolean setUserInfoHolder(String userinfo, String token, Long tenantId, HandlerMethod method) {
        JSONObject userInfo = JSON.parseObject((String)userinfo);
        if (userInfo == null) {
            this.logger.warn("TokenParser: userinfo = " + userinfo);
            return false;
        }
        AuthorizedUser authorizedUser = new AuthorizedUser();
        authorizedUser.setTenantName(userInfo.get("tenantName") + "");
        authorizedUser.setUsername(userInfo.get("username") + "");
        authorizedUser.setAccountId(Long.parseLong(userInfo.get("accountId") + ""));
        authorizedUser.setEmail(userInfo.get("email") + "");
        authorizedUser.setTenantCode(userInfo.get("tenantCode") + "");
        authorizedUser.setTenantId(Long.parseLong(userInfo.get("tenantId") + ""));
        authorizedUser.setMobile(userInfo.get("mobile") + "");
        authorizedUser.setId(Long.parseLong(userInfo.get("id") + ""));
        authorizedUser.setToken(token);
        UserInfoHolder.put((IAuthorizedUser)authorizedUser);
        this.logger.info("TokenParser: setUserInfoHolder:  UserSessionInfo {}", (Object)JSON.toJSON((Object)authorizedUser).toString());
        return true;
    }

    private void responseUnauthorized(String message, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType("application/json;charset=UTF-8");
        response.setStatus(401);
        LinkedHashMap<String, String> error = new LinkedHashMap<String, String>();
        error.put("code", "0");
        error.put("message", message);
        error.put("loginUrl", this.loginUrl);
        response.getWriter().write(JSON.toJSONString(error));
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        UserInfoHolder.clearContext();
        ReqParamsHolder.clear();
    }

    public static interface JwtConstants {
        public static final String TYPE_KEY = "type";
        public static final String USERINFO_KEY = "userinfo";
    }
}

