/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.eccp.x.domain.common.utils;

import com.xforceplus.eccp.x.domain.common.utils.SpringContextUtil;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class AsyncUtil {
    private static final Logger log = LoggerFactory.getLogger(AsyncUtil.class);
    @Autowired
    private Executor executor;

    @Async
    public <T> void asyncRun(T t, Consumer<T> consumer) {
        consumer.accept(t);
    }

    public <T> void run(boolean isAsync, T t, Consumer<T> consumer) {
        if (!isAsync) {
            consumer.accept(t);
            return;
        }
        List<AsyncUtil> asyncUtils = SpringContextUtil.getBeans(AsyncUtil.class);
        if (CollectionUtils.isNotEmpty(asyncUtils)) {
            asyncUtils.get(0).asyncRun(t, consumer);
        }
    }

    public <T> void runAsync(boolean isAsync, List<T> params, Consumer<T> consumer) {
        if (isAsync) {
            for (T param : params) {
                consumer.accept(param);
            }
        } else {
            List<AsyncUtil> asyncUtils = SpringContextUtil.getBeans(AsyncUtil.class);
            if (CollectionUtils.isEmpty(asyncUtils)) {
                return;
            }
            CountDownLatch countDownLatch = new CountDownLatch(params.size());
            for (Object param : params) {
                this.executor.execute(() -> {
                    consumer.accept(param);
                    countDownLatch.countDown();
                });
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                log.error("", (Throwable)e);
            }
        }
    }
}

