/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.eccp.x.domain.common.utils;

import com.xforceplus.eccp.common.stub.CommonException;
import com.xforceplus.eccp.common.stub.ErrorEnum;
import com.xforceplus.eccp.x.domain.common.constant.BizError;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LockUtil {
    private static final Logger log = LoggerFactory.getLogger(LockUtil.class);
    @Autowired
    private RedissonClient redissonClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R withLock(String lockKey, Integer retryNum, Integer totalRetryNum, Function<String, R> func) {
        RLock lock = null;
        try {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{lockKey})) {
                lock = this.redissonClient.getLock(lockKey);
                if (lock.isLocked()) {
                    if (retryNum < totalRetryNum) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception e) {
                            log.error("Thread.sleep(1000) failed!", (Throwable)e);
                        }
                        R r = this.withLock(lockKey, retryNum + 1, totalRetryNum, func);
                        return r;
                    }
                    log.error("LockUtil.withLock retry timeout:{}", (Object)lockKey);
                    throw new CommonException((ErrorEnum)BizError.SOURCE_LOCKED);
                }
                lock.lock();
            }
            R r = func.apply(lockKey);
            return r;
        }
        finally {
            if (Objects.nonNull(lock) && lock.isLocked() && lock.isHeldByCurrentThread()) {
                try {
                    lock.unlock();
                }
                catch (Exception e) {
                    log.warn("LockUtil.withLock forceUnlock:{}", (Object)lockKey);
                    lock.forceUnlock();
                }
            }
        }
    }
}

