/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.eccp.x.domain.common.utils;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OptionalUtil {
    public static <T, R> R of(T t, Function<T, R> func) {
        if (Objects.isNull(t)) {
            return null;
        }
        return func.apply(t);
    }

    public static <T> void then(T t, Consumer<T> consumer) {
        if (Objects.nonNull(t)) {
            consumer.accept(t);
        }
    }

    public static String orDefaultString(String t, Function<String, String> func) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{t})) {
            return t;
        }
        return func.apply(t);
    }

    public static <T, R1, R2> R2 of2(T t, Function<T, R1> func1, Function<R1, R2> func2) {
        R1 r1 = OptionalUtil.of(t, func1);
        if (Objects.isNull(r1)) {
            return null;
        }
        return func2.apply(r1);
    }

    public static <T, R> R of(List<T> t, Function<List<T>, R> func) {
        if (CollectionUtils.isEmpty(t)) {
            return null;
        }
        return func.apply(t);
    }
}

