package com.xforceplus.elephant.image.openapi.client.api;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.openapi.client.model.*;

import java.util.List;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "bill", description = "the bill API", tags = "bill")
public interface BillApi {

    @ApiOperation(value = "调阅影像详情页", notes = "调阅影像详情页" , authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/bill/getImageUrl",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getImageUrl(@ApiParam(value = "request" ,required=true )  @Valid  GetImageUrlRequest request
);


    @ApiOperation(value = "保存单据", notes = "保存单据" , authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/bill/saveBillData",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse saveBillData(@ApiParam(value = "request" ,required=true )  @Valid  SaveBillDataRequest request
);


    @ApiOperation(value = "接收单据", notes = "接收单据" , authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/bill/receiveBillData",
            produces = { "application/json" },
            method = RequestMethod.POST)
    CommonResponse receiveBillData(@ApiParam(value = "request" ,required=true )  @Valid  SaveBillDataRequest request
    );


    @ApiOperation(value = "单据状态变更", notes = "单据状态变更" , authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/bill/updateBillStatus",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse updateBillStatus(@ApiParam(value = "request" ,required=true )  @Valid  UpdateBillStatusRequest request
);

    @ApiOperation(value = "单据下发", notes = "单据下发" , authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/bill/syncBill",
            produces = { "application/json" },
            method = RequestMethod.POST)
    CommonResponse syncBill(@ApiParam(value = "request" ,required=true )  @RequestBody SyncBillRequest request
    );


    @ApiOperation(value = "单据信息获取", notes = "单据信息获取" , authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/bill/imageData",
            produces = { "application/json" },
            method = RequestMethod.GET)
    CommonResponse imageData(@ApiParam(value = "request" ,required=true )  @Valid ImageDataRequest request
    );
}
