package com.xforceplus.elephant.image.openapi.client.api;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.openapi.client.model.SaveAuditFileRequest;
import com.xforceplus.elephant.image.openapi.client.model.SaveFileRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "file", description = "the file API", tags = "file")
public interface FileApi {

    @ApiOperation(value = "保存审批流文件", notes = "保存审批流文件" , authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/file/saveAuditFile",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse saveAuditFile(@ApiParam(value = "request" ,required=true )  @Valid  SaveAuditFileRequest request
);


    @ApiOperation(value = "保存影像文件", notes = "保存影像文件" , authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/file",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse saveFile(@ApiParam(value = "request" ,required=true )  @Valid  SaveFileRequest request
);

}
