package com.xforceplus.elephant.image.openapi.client.api;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.openapi.client.model.SaveLogApiRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "log", description = "the log API", tags = "log")
public interface LogApi {

    @ApiOperation(value = "新增日志", notes = "新增日志" , authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/log/saveLogApi",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse saveLogApi(@ApiParam(value = "request" ,required=true )  @Valid  SaveLogApiRequest request
);

}
