package com.xforceplus.elephant.image.openapi.client.api;

import com.xforceplus.elephant.image.openapi.client.model.*;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import java.util.List;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "ticket", description = "the ticket API", tags = "ticket")
public interface TicketApi {

    @ApiOperation(value = "单证退回", notes = "单证退回" , authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/ticket/backTicket",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse backTicket(@ApiParam(value = "request" ,required=true )  @Valid BackTicketRequest request
);


    @ApiOperation(value = "保存单证", notes = "保存单证" , authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/ticket/saveTicket",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse saveTicket(@ApiParam(value = "request" ,required=true )  @Valid  List<SaveTicketObj> request
);



    @ApiOperation(value = "更新影像地址", notes = "更新影像地址" , authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/ticket/updateImageUrl",
            produces = { "application/json" },
            method = RequestMethod.POST)
    CommonResponse updateImageUrl(@ApiParam(value = "request" ,required=true )  @Valid  UpdateImageUrlRequest request
    );


    @ApiOperation(value = "保存增值税发票", notes = "保存增值税发票" , authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/ticket/saveTicketInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    CommonResponse saveTicketInvoice(@ApiParam(value = "request" ,required=true )  @Valid SaveTicketInvoiceRequest request
    );

    @ApiOperation(value = "发票状态变更", notes = "发票状态变更" , authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/ticket/updateTicketStatus",
            produces = { "application/json" },
            method = RequestMethod.POST)
    CommonResponse updateTicketStatus(@ApiParam(value = "request" ,required=true )  @Valid UpdateTicketStatusRequest request
    );

    @ApiOperation(value = "进项发票状态变更", notes = "进项发票状态变更" , authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/ticket/inUpdateTicketStatus",
            produces = { "application/json" },
            method = RequestMethod.POST)
    CommonResponse inUpdateTicketStatus(@ApiParam(value = "request" ,required=true )  @Valid InUpdateTicketStatusRequest request
    );

}
