package com.xforceplus.elephant.image.openapi.client.api;

import com.xforceplus.elephant.image.openapi.client.model.QueryTenantsInvoiceRequest;
import com.xforceplus.elephant.image.openapi.client.model.SimpleQueryRequest;
import com.xforceplus.elephant.image.openapi.client.model.UpdateInvoiceRequest;
import com.xforceplus.openapi.domain.entity.common.DataListResult;
import com.xforceplus.openapi.domain.entity.common.OpenApiResponseV2;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Map;
import javax.validation.Valid;

import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import reactor.core.publisher.Mono;

/**
 * 发票全局接口
 * @author rongying
 * @date 2023/6/21 13:47
 */
public interface TicketGlobalApi {

    @ApiOperation(value = "集团维度查询发票信息", notes = "集团维度查询发票信息" , authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/invoice/v1/tenants/action/query",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
    Mono<OpenApiResponseV2<DataListResult<Map<String, Object>>>> queryTenantsInvoice(@ApiParam(value = "request" ,required=true )  @Valid QueryTenantsInvoiceRequest request);

    @ApiOperation(value = "租户维度查询发票信息", notes = "租户维度查询发票信息" , authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/invoice/v1/tenant/{tenantCode}/action/query",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Mono<OpenApiResponseV2<DataListResult<Map<String, Object>>>> queryTenantInvoices(@PathVariable String tenantCode,
                                                                                     @RequestBody SimpleQueryRequest request);

    @ApiOperation(value = "租户维度发票状态修改", notes = "租户维度发票状态修改" , authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/invoice/v1/tenant/{tenantCode}/action/update",
            produces = { "application/json" },
            method = RequestMethod.PUT)
    Mono<OpenApiResponseV2<Integer>> invoiceStatusUpdate(@PathVariable String tenantCode,
                                                         @RequestBody UpdateInvoiceRequest request);

}
