package com.xforceplus.elephant.image.openapi.client.enums;

import java.util.Arrays;

public enum ConditionGroupType {

    AND("and","并关系"),
    OR("or","或关系"),
    ;


    ConditionGroupType(String type, String desc){
        this.type = type;
        this.desc = desc;
    }
    private String type;
    private String desc;

    public static ConditionGroupType fromType(String type){
        return Arrays.stream(ConditionGroupType.values())
                .filter(o -> o.getType().equalsIgnoreCase(type))
                .findFirst()
                .orElseThrow(()->new RuntimeException("条件分组类型["+type+"]未找到"));
    }

    public String getType(){
        return type;
    }
}
