package com.xforceplus.elephant.image.openapi.client.enums;


import java.util.Arrays;

public enum Operation {

    EQ("eq","等于"),
    NE("ne","不等于"),
    GT("gt","大于"),
    GE("ge","大于等于"),
    LT("lt","小于"),
    LE("le","小于等于"),
    IN("in","集合内"),
    NOT_IN("not in","集合外"),
    IS_NULL("is null","为空"),
    NOT_NULL("not null","不为空"),
    LIKE("like","模糊搜索"),
    ;


    Operation (String type,String desc){
        this.type = type;
        this.desc = desc;
    }
    private String type;
    private String desc;

    public String getType(){
        return type;
    }

    public static Operation fromType(String type){
        return Arrays.stream(Operation.values())
                .filter(o -> o.getType().equalsIgnoreCase(type))
                .findFirst()
                .orElseThrow(()->new RuntimeException("条件类型["+type+"]未找到"));
    }

    public String getDesc() {
        return desc;
    }
}
