package com.xforceplus.elephant.image.openapi.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 批量退回单证
 */
@ApiModel(description = "批量退回单证")

@JsonInclude(NON_NULL)
public class BackTicketObj {
  @JsonProperty("tenantId")
  private String tenantId = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("ticketCode")
  private String ticketCode = null;

  @JsonProperty("imageId")
  private String imageId = null;

  @JsonProperty("returnRemark")
  private String returnRemark = null;

  @JsonProperty("userId")
  private String userId = null;

  @JsonProperty("userName")
  private String userName = null;

  @JsonProperty("handleType")
  private Integer handleType = null;

  @JsonIgnore
  public BackTicketObj tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public BackTicketObj invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public BackTicketObj invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public BackTicketObj ticketCode(String ticketCode) {
    this.ticketCode = ticketCode;
    return this;
  }

   /**
   * 发票类型
   * @return ticketCode
  **/
  @ApiModelProperty(value = "发票类型")
  public String getTicketCode() {
    return ticketCode;
  }

  public void setTicketCode(String ticketCode) {
    this.ticketCode = ticketCode;
  }

  @JsonIgnore
  public BackTicketObj imageId(String imageId) {
    this.imageId = imageId;
    return this;
  }

   /**
   * 影像id
   * @return imageId
  **/
  @ApiModelProperty(value = "影像id")
  public String getImageId() {
    return imageId;
  }

  public void setImageId(String imageId) {
    this.imageId = imageId;
  }

  @JsonIgnore
  public BackTicketObj returnRemark(String returnRemark) {
    this.returnRemark = returnRemark;
    return this;
  }

   /**
   * 退回备注
   * @return returnRemark
  **/
  @ApiModelProperty(value = "退回备注")
  public String getReturnRemark() {
    return returnRemark;
  }

  public void setReturnRemark(String returnRemark) {
    this.returnRemark = returnRemark;
  }

  @JsonIgnore
  public BackTicketObj userId(String userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户id
   * @return userId
  **/
  @ApiModelProperty(value = "用户id")
  public String getUserId() {
    return userId;
  }

  public void setUserId(String userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public BackTicketObj userName(String userName) {
    this.userName = userName;
    return this;
  }

   /**
   * 用户名
   * @return userName
  **/
  @ApiModelProperty(value = "用户名")
  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  @JsonIgnore
  public BackTicketObj handleType(Integer handleType) {
    this.handleType = handleType;
    return this;
  }

   /**
   * 1-退回重扫，2-数据退回
   * @return handleType
  **/
  @ApiModelProperty(value = "1-退回重扫，2-数据退回")
  public Integer getHandleType() {
    return handleType;
  }

  public void setHandleType(Integer handleType) {
    this.handleType = handleType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BackTicketObj backTicketObj = (BackTicketObj) o;
    return Objects.equals(this.tenantId, backTicketObj.tenantId) &&
        Objects.equals(this.invoiceNo, backTicketObj.invoiceNo) &&
        Objects.equals(this.invoiceCode, backTicketObj.invoiceCode) &&
        Objects.equals(this.ticketCode, backTicketObj.ticketCode) &&
        Objects.equals(this.imageId, backTicketObj.imageId) &&
        Objects.equals(this.returnRemark, backTicketObj.returnRemark) &&
        Objects.equals(this.userId, backTicketObj.userId) &&
        Objects.equals(this.userName, backTicketObj.userName) &&
        Objects.equals(this.handleType, backTicketObj.handleType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, invoiceNo, invoiceCode, ticketCode, imageId, returnRemark, userId, userName, handleType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BackTicketObj {\n");
    
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    ticketCode: ").append(toIndentedString(ticketCode)).append("\n");
    sb.append("    imageId: ").append(toIndentedString(imageId)).append("\n");
    sb.append("    returnRemark: ").append(toIndentedString(returnRemark)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
    sb.append("    handleType: ").append(toIndentedString(handleType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
